/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java;

import android.app.Application;
import android.util.Log;
import com.anythink.core.api.ATSDK;
import com.applovin.sdk.AppLovinMediationProvider;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.google.android.gms.ads.MobileAds;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener;
import com.appstock.demo.java.utils.Settings;
import com.appstock.sdk.api.Appstock;


public class TheApplication extends Application {

    private static final String TAG = "PrebidCustomApplication";

    @Override
    public void onCreate() {
        super.onCreate();

        Settings.init(this);
        initAppstockSdk();
        initAdMob();
        initApplovinMax();
        initTopOn();
        initIronSource();
    }

    public void initAppstockSdk() {
        // WL_CHANGE
        Appstock.initializeSdk(this, "appstock-demo");
    }

    public void initAdMob() {
        MobileAds.initialize(this);
    }

    public void initApplovinMax() {
        AppLovinSdkInitializationConfiguration config = AppLovinSdkInitializationConfiguration
                .builder(
                        "1tLUnP4cVQqpHuHH2yMtfdESvvUhTB05NdbCoDTceDDNVnhd_T8kwIzXDN9iwbdULTboByF-TtNaiTmsoVbxZw",
                        this
                )
                .setMediationProvider(AppLovinMediationProvider.MAX)
                .build();

        AppLovinSdk.getInstance(this).initialize(config, (it) -> {
            Log.d("ApplovinInitialization", "Initialization result: " + it);
        });
    }

    private void initTopOn() {
        ATSDK.init(this, "h66dacef4f35df", "5c591f747ce5992032eaffa7913f3109");
    }

    /**
     * We set up empty rewarded listener for manual loading mode.
     */
    private void initIronSource() {
        IronSource.setLevelPlayRewardedVideoManualListener(new LevelPlayRewardedVideoManualListener() {
            @Override
            public void onAdReady(AdInfo adInfo) {
            }

            @Override
            public void onAdLoadFailed(IronSourceError ironSourceError) {
            }

            @Override
            public void onAdOpened(AdInfo adInfo) {
            }

            @Override
            public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
            }

            @Override
            public void onAdClicked(Placement placement, AdInfo adInfo) {
            }

            @Override
            public void onAdRewarded(Placement placement, AdInfo adInfo) {
            }

            @Override
            public void onAdClosed(AdInfo adInfo) {
            }
        });
        IronSource.init(this, "24f2f5e8d");
    }

}
