/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities;

import android.os.Bundle;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.databinding.DataBindingUtil;
import com.appstock.demo.java.R;
import com.appstock.demo.java.databinding.ActivityDemoBinding;
import com.appstock.demo.java.testcases.TestCase;
import com.appstock.demo.java.testcases.TestCaseRepository;

public class BaseAdActivity extends AppCompatActivity {

    protected static final String TAG = "AdExampleActivity";
    protected ActivityDemoBinding binding;

    private TestCase testCase = TestCaseRepository.lastTestCase;

    @Override
    @CallSuper
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_demo);
        binding.tvTestCaseName.setText(testCase.getName());
    }

    protected ViewGroup getContainerForAd() {
        return binding.frameAdWrapper;
    }

}
