/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.applovin;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.appstock.demo.java.R;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.sdk.api.adunits.nativead.request.*;
import com.appstock.sdk.api.adunits.nativead.response.NativeEventTracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AppLovinNativeActivity extends BaseAdActivity {

    private static final String APP_LOVIN_AD_UNIT_ID = "f950fc0a3bec5d3a";

    private MaxNativeAdLoader appLovinLoader;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (appLovinLoader != null) {
            appLovinLoader.destroy();
        }
    }


    private void createAd() {
        // 1. Create MaxNativeAdLoader
        appLovinLoader = new MaxNativeAdLoader(APP_LOVIN_AD_UNIT_ID, this);
        appLovinLoader.setNativeAdListener(createListener(getContainerForAd()));

        // 2. Create native ad config and set it to local extras
        AppstockNativeAdConfig nativeAdConfig = createNativeConfig();
        appLovinLoader.setLocalExtraParameter(AppstockNativeAdConfig.KEY_EXTRAS, nativeAdConfig);

        // 3. Create custom native view
        MaxNativeAdView adView = createCustomView();

        // 4. Load ad
        appLovinLoader.loadAd(adView);
    }


    private AppstockNativeAdConfig createNativeConfig() {
        ArrayList<NativeEventTracker.EventTrackingMethod> eventTrackingMethods = new ArrayList<>(
                Arrays.asList(
                        NativeEventTracker.EventTrackingMethod.IMAGE,
                        NativeEventTracker.EventTrackingMethod.JS
                )
        );
        NativeEventTracker eventTracker = new NativeEventTracker(
                NativeEventTracker.EventType.IMPRESSION,
                eventTrackingMethods
        );

        NativeTitleAsset title = new NativeTitleAsset();
        title.setLength(90);
        title.setRequired(true);

        NativeImageAsset icon = new NativeImageAsset(20, 20, 20, 20);
        icon.setImageType(NativeImageAsset.ImageType.ICON);
        icon.setRequired(true);

        NativeImageAsset mainImage = new NativeImageAsset(200, 200, 200, 200);
        mainImage.setImageType(NativeImageAsset.ImageType.MAIN);
        mainImage.setRequired(true);

        NativeDataAsset sponsored = new NativeDataAsset();
        sponsored.setLen(90);
        sponsored.setDataType(NativeDataAsset.DataType.SPONSORED);
        sponsored.setRequired(true);


        NativeDataAsset description = new NativeDataAsset();
        description.setDataType(NativeDataAsset.DataType.DESC);
        description.setRequired(true);

        NativeDataAsset ctaText = new NativeDataAsset();
        ctaText.setDataType(NativeDataAsset.DataType.CTATEXT);
        ctaText.setRequired(true);

        List<NativeAsset> assets = Arrays.asList(
                title,
                icon,
                mainImage,
                sponsored,
                description,
                ctaText
        );

        return new AppstockNativeAdConfig.Builder()
                .setContextType(NativeContextType.SOCIAL_CENTRIC)
                .setPlacementType(NativePlacementType.CONTENT_FEED)
                .setContextSubType(NativeContextSubtype.GENERAL_SOCIAL)
                .setNativeEventTrackers(Collections.singletonList(eventTracker))
                .setNativeAssets(assets)
                .build();
    }

    private MaxNativeAdView createCustomView() {
        MaxNativeAdViewBinder builder = new MaxNativeAdViewBinder.Builder(R.layout.view_native_ad_max)
                .setTitleTextViewId(R.id.tvHeadline)
                .setBodyTextViewId(R.id.tvBody)
                .setIconImageViewId(R.id.imgIco)
                .setMediaContentViewGroupId(R.id.frameMedia)
                .setCallToActionButtonId(R.id.btnCallToAction)
                .build();

        MaxNativeAdView adView = new MaxNativeAdView(builder, this);
        return adView;
    }

    private static MaxNativeAdListener createListener(ViewGroup containerForAd) {
        return new MaxNativeAdListener() {
            @Override
            public void onNativeAdLoaded(@Nullable MaxNativeAdView maxNativeAdView, @NonNull MaxAd maxAd) {
                super.onNativeAdLoaded(maxNativeAdView, maxAd);

                // 5. Show ad
                containerForAd.removeAllViews();
                containerForAd.addView(maxNativeAdView);
            }

            @Override
            public void onNativeAdLoadFailed(@NonNull String s, @NonNull MaxError maxError) {
                Log.e(TAG, "Can't download native ad: " + maxError.getMessage());
            }
        };
    }

}
