/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.applovin;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.appstock.demo.java.activities.BaseAdActivity;
import org.jetbrains.annotations.NotNull;

public class AppLovinRewardedActivity extends BaseAdActivity {

    private static final String APP_LOVIN_AD_UNIT_ID = "2910d37545db01ec";

    private MaxRewardedAd appLovinAdUnit;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (appLovinAdUnit != null) {
            appLovinAdUnit.destroy();
        }
    }


    private void createAd() {
        // 1. Create MaxRewardedAd
        appLovinAdUnit = MaxRewardedAd.getInstance(APP_LOVIN_AD_UNIT_ID, this);

        // 2. Configure ad unit
        appLovinAdUnit.setListener(createListener(appLovinAdUnit));

        // 3. Load ad
        appLovinAdUnit.loadAd();
    }

    private static MaxRewardedAdListener createListener(MaxRewardedAd ad) {
        return new MaxRewardedAdListener() {

            @Override
            public void onAdLoaded(@NonNull MaxAd maxAd) {
                Log.d(TAG, "Ad loaded successfully");

                // 4. Show ad
                ad.showAd();
            }

            @Override
            public void onUserRewarded(@NonNull MaxAd maxAd, MaxReward maxReward) {
                Log.d(TAG, "User earned reward: " + maxReward.getLabel() + " " + maxReward.getAmount());
            }

            @Override
            public void onAdLoadFailed(@NonNull String s, @NonNull MaxError maxError) {
                Log.e(TAG, "Ad loading failed: " + maxError.getMessage());
            }

            @Override
            public void onAdDisplayFailed(@NonNull MaxAd maxAd, @NonNull MaxError maxError) {
                Log.e(TAG, "Ad displaying failed: " + maxError.getMessage());
            }

            @Override
            public void onAdDisplayed(@NonNull MaxAd maxAd) {
            }

            @Override
            public void onAdHidden(@NonNull MaxAd maxAd) {
            }

            @Override
            public void onAdClicked(@NonNull MaxAd maxAd) {
            }
        };
    }

}
