/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.inapp;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.sdk.api.adunits.AppstockAdView;
import com.appstock.sdk.api.adunits.AppstockAdViewListener;
import com.appstock.sdk.api.adunits.AppstockAdViewVideoListener;
import com.appstock.sdk.api.adunits.utils.AppstockAdException;
import com.appstock.sdk.api.adunits.utils.AppstockAdSize;
import com.appstock.sdk.api.adunits.utils.AppstockAdUnitFormat;
import com.appstock.sdk.api.AdInfo;
import com.appstock.sdk.api.adunits.utils.AppstockVideoPlacementType;

public class AppstockVideoBannerActivity extends BaseAdActivity {

    private static final String PLACEMENT_ID = "8";
    private static final int WIDTH = 300;
    private static final int HEIGHT = 250;

    private AppstockAdView adView;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adView != null) {
            adView.destroy();
        }
    }

    private void createAd() {
        // 1. Create AppstockAdView
        adView = new AppstockAdView(this);

        // 2. Configure ad unit
        adView.setPlacementId(PLACEMENT_ID);
        adView.setAdSizes(new AppstockAdSize(WIDTH, HEIGHT));
        adView.setVideoPlacementType(AppstockVideoPlacementType.IN_BANNER);
        adView.setAdViewListener(createListener());
        adView.setVideoAdListener(createVideoListener());
        adView.setAdUnitFormat(AppstockAdUnitFormat.VIDEO);

        // 3. Load ad
        adView.loadAd();

        // 4. Add AppstockAdView to the app UI
        getContainerForAd().addView(adView);
    }


    private static AppstockAdViewListener createListener() {
        return new AppstockAdViewListener() {
            @Override
            public void onAdLoaded(AppstockAdView AppstockAdView, AdInfo adInfo) {
                // Called when ad loaded
                Log.d(TAG, "Ad loaded successfully");
            }

            @Override
            public void onAdFailed(AppstockAdView AppstockAdView, AppstockAdException e) {
                // Called when ad failed to load
                Log.e(TAG, "Ad failed to load: " + e.getMessage());
            }

            @Override
            public void onAdDisplayed(AppstockAdView AppstockAdView) {
                // Called when ad displayed on screen
            }

            @Override
            public void onAdClicked(AppstockAdView AppstockAdView) {
                // Called when ad clicked
            }

            @Override
            public void onAdClosed(AppstockAdView AppstockAdView) {
                // Called when ad hidden
            }
        };
    }

    private static AppstockAdViewVideoListener createVideoListener() {
        return new AppstockAdViewVideoListener() {
            @Override
            public void onVideoCompleted(AppstockAdView AppstockAdView) {
                // Called when video ad completed
                Log.d(TAG, "Video completed");
            }

            @Override
            public void onVideoPaused(AppstockAdView AppstockAdView) {
                // Called when video ad paused
            }

            @Override
            public void onVideoResumed(AppstockAdView AppstockAdView) {
                // Called when video ad resumed
            }

            @Override
            public void onVideoUnMuted(AppstockAdView AppstockAdView) {
                // Called when video ad un muted
            }

            @Override
            public void onVideoMuted(AppstockAdView AppstockAdView) {
                // Called when video ad muted
            }
        };
    }

}
