/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.inapp;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.sdk.api.adunits.AppstockInterstitialAdUnit;
import com.appstock.sdk.api.adunits.AppstockInterstitialAdUnitListener;
import com.appstock.sdk.api.adunits.utils.AppstockAdException;
import com.appstock.sdk.api.AdInfo;
import com.appstock.sdk.api.adunits.utils.AppstockAdUnitFormat;

import java.util.EnumSet;

public class AppstockVideoInterstitialActivity extends BaseAdActivity {

    private static final String PLACEMENT_ID = "7";

    private AppstockInterstitialAdUnit adUnit;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adUnit != null) {
            adUnit.destroy();
        }
    }


    private void createAd() {
        // 1. Create AppstockInterstitialAdUnit
        adUnit = new AppstockInterstitialAdUnit(this);

        // 2. Configure ad unit
        adUnit.setPlacementId(PLACEMENT_ID);
        adUnit.setInterstitialAdUnitListener(createListener());
        adUnit.setAdUnitFormats(EnumSet.of(AppstockAdUnitFormat.VIDEO));

        // 3. Load ad
        adUnit.loadAd();
    }

    private static AppstockInterstitialAdUnitListener createListener() {
        return new AppstockInterstitialAdUnitListener() {
            @Override
            public void onAdLoaded(AppstockInterstitialAdUnit adUnit, AdInfo adInfo) {
                // Called when ad loaded
                Log.d(TAG, "Ad loaded successfully");

                // 4. Show ad
                adUnit.show();
            }

            @Override
            public void onAdDisplayed(AppstockInterstitialAdUnit adUnit) {
                // Called when ad displayed full screen
                Log.d(TAG, "Ad displayed");
            }

            @Override
            public void onAdFailed(AppstockInterstitialAdUnit adUnit, AppstockAdException e) {
                // Called when ad failed
                Log.e(TAG, "Ad failed to load: " + e.getMessage());
            }

            @Override
            public void onAdClicked(AppstockInterstitialAdUnit adUnit) {
                // Called when ad clicked
            }

            @Override
            public void onAdClosed(AppstockInterstitialAdUnit adUnit) {
                // Called when ad closed
            }
        };
    }

}
