/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.inapp;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.sdk.api.adunits.AppstockRewardedAdUnit;
import com.appstock.sdk.api.adunits.AppstockRewardedAdUnitListener;
import com.appstock.sdk.api.adunits.utils.AppstockAdException;
import com.appstock.sdk.api.AdInfo;
import com.appstock.sdk.rendering.bidding.data.bid.rewarded.Reward;

public class AppstockVideoRewardedActivity extends BaseAdActivity {

    private static final String PLACEMENT_ID = "16";

    private AppstockRewardedAdUnit adUnit;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adUnit != null) {
            adUnit.destroy();
        }
    }


    private void createAd() {
        // 1. Create ad unit
        adUnit = new AppstockRewardedAdUnit(this);

        // 2. Configure ad unit
        adUnit.setPlacementId(PLACEMENT_ID);
        adUnit.setRewardedAdUnitListener(createListener());

        // 3. Load ad
        adUnit.loadAd();
    }

    private static AppstockRewardedAdUnitListener createListener() {
        return new AppstockRewardedAdUnitListener() {
            @Override
            public void onAdLoaded(AppstockRewardedAdUnit adUnit, AdInfo adInfo) {
                // Called when ad loaded
                Log.d(TAG, "Ad loaded successfully");

                // 4. Show ad
                adUnit.show();
            }

            @Override
            public void onReward(AppstockRewardedAdUnit adUnit, @Nullable Reward reward) {
                if (reward == null) {
                    Log.d(TAG, "User earned empty reward!");
                    return;
                }
                // Called when user earned reward
                Log.d(TAG, "User earned reward: " + reward.getCount() + " " + reward.getType());
            }

            @Override
            public void onAdDisplayed(AppstockRewardedAdUnit adUnit) {
                // Called when ad displayed full screen
                Log.d(TAG, "Ad displayed");
            }

            @Override
            public void onAdFailed(AppstockRewardedAdUnit adUnit, AppstockAdException e) {
                // Called when ad failed to load
                Log.e(TAG, "Ad failed to load: " + e.getMessage());
            }

            @Override
            public void onAdClicked(AppstockRewardedAdUnit adUnit) {
                // Called when ad clicked
            }

            @Override
            public void onAdClosed(AppstockRewardedAdUnit adUnit) {
                // Called when ad closed
            }
        };
    }

}
