/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.ironsource;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayBannerListener;
import com.appstock.demo.java.activities.BaseAdActivity;
import org.jetbrains.annotations.NotNull;

public class IronSourceBannerActivity extends BaseAdActivity {

    private static final int WIDTH = 300;
    private static final int HEIGHT = 250;

    private IronSourceBannerLayout adView;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    protected void onResume() {
        super.onResume();
        IronSource.onResume(this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        IronSource.onPause(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        IronSource.destroyBanner(adView);
    }


    private void createAd() {
        // 1. Create ad view
        adView = IronSource.createBanner(this, new ISBannerSize(WIDTH, HEIGHT));

        // 2. Configure ad view
        adView.setLevelPlayBannerListener(createListener());
        adView.setLayoutParams(
                new ViewGroup.LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        (int) (getResources().getDisplayMetrics().density * HEIGHT)
                )
        );

        // 3. Load ad
        IronSource.loadBanner(adView);

        // 4. Add ad view to the UI
        binding.frameAdWrapper.addView(adView);
    }

    private static @NotNull LevelPlayBannerListener createListener() {
        return new LevelPlayBannerListener() {
            @Override
            public void onAdLoaded(AdInfo adInfo) {

            }

            @Override
            public void onAdLoadFailed(IronSourceError error) {
                Log.e(TAG, "Ad loading failed: " + error);
            }

            @Override
            public void onAdClicked(AdInfo adInfo) {

            }

            @Override
            public void onAdLeftApplication(AdInfo adInfo) {

            }

            @Override
            public void onAdScreenPresented(AdInfo adInfo) {

            }

            @Override
            public void onAdScreenDismissed(AdInfo adInfo) {

            }
        };
    }

}
