/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.ironsource;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayInterstitialListener;
import com.appstock.demo.java.activities.BaseAdActivity;
import org.jetbrains.annotations.NotNull;

public class IronSourceInterstitialActivity extends BaseAdActivity {

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }


    private void createAd() {
        // 1. Load ad
        IronSource.setLevelPlayInterstitialListener(createListener());
        IronSource.loadInterstitial();
    }

    private static @NotNull LevelPlayInterstitialListener createListener() {
        return new LevelPlayInterstitialListener() {
            @Override
            public void onAdReady(AdInfo adInfo) {
                // 2. Show ad
                IronSource.showInterstitial();
            }

            @Override
            public void onAdLoadFailed(IronSourceError error) {
                Log.e(TAG, "Ad loading failed: " + error);
            }

            @Override
            public void onAdOpened(AdInfo adInfo) {

            }

            @Override
            public void onAdShowSucceeded(AdInfo adInfo) {

            }

            @Override
            public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {

            }

            @Override
            public void onAdClicked(AdInfo adInfo) {

            }

            @Override
            public void onAdClosed(AdInfo adInfo) {

            }
        };
    }

}
