/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.ironsource;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener;
import com.appstock.demo.java.activities.BaseAdActivity;

public class IronSourceRewardedActivity extends BaseAdActivity {

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }


    private void createAd() {
        // 1. Load ad
        IronSource.setLevelPlayRewardedVideoManualListener(createListener());
        IronSource.loadRewardedVideo();
    }

    private static LevelPlayRewardedVideoManualListener createListener() {
        return new LevelPlayRewardedVideoManualListener() {
            @Override
            public void onAdReady(AdInfo adInfo) {
                // 2. Show ad
                IronSource.showRewardedVideo();
            }

            @Override
            public void onAdLoadFailed(IronSourceError error) {
                Log.e(TAG, "Ad loading failed: " + error);
            }

            @Override
            public void onAdOpened(AdInfo adInfo) {
            }

            @Override
            public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
            }

            @Override
            public void onAdClicked(Placement placement, AdInfo adInfo) {
            }

            @Override
            public void onAdRewarded(Placement placement, AdInfo adInfo) {
            }

            @Override
            public void onAdClosed(AdInfo adInfo) {
            }
        };
    }

}
