/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.topon;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.anythink.banner.api.ATBannerListener;
import com.anythink.banner.api.ATBannerView;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.AdError;
import com.appstock.sdk.topon.AppstockBannerAdapter;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.sdk.api.adunits.AppstockAdView;
import com.appstock.sdk.api.adunits.AppstockAdViewListener;
import com.appstock.sdk.api.adunits.utils.AppstockAdException;
import com.appstock.sdk.api.adunits.utils.AppstockAdSize;
import com.appstock.sdk.rendering.networking.urlBuilder.BidPathBuilder;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;

public class TopOnBannerActivity extends BaseAdActivity {

    private static final int WIDTH = 320;
    private static final int HEIGHT = 50;
    private static final String AD_UNIT_ID = "n1fskug7bljq83";

    private ATBannerView adView;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adView != null) {
            adView.destroy();
        }
    }


    private void createAd() {
        // 1. Create ad view
        adView = new ATBannerView(this);

        // 2. Configure ad view
        adView.setPlacementId(AD_UNIT_ID);
        adView.setLayoutParams(new FrameLayout.LayoutParams(getResources().getDisplayMetrics().widthPixels, ViewGroup.LayoutParams.WRAP_CONTENT));
        adView.setBannerAdListener(createListener());

        // Set sizes for TopOn banner and for Appstock banner
        HashMap<String, Object> localExtras = new HashMap<>();
        localExtras.put(ATAdConst.KEY.AD_WIDTH, getResources().getDisplayMetrics().widthPixels);
        localExtras.put(ATAdConst.KEY.AD_HEIGHT, HEIGHT * getResources().getDisplayMetrics().density);
        localExtras.put(AppstockBannerAdapter.KEY_WIDTH, WIDTH);
        localExtras.put(AppstockBannerAdapter.KEY_HEIGHT, HEIGHT);
        adView.setLocalExtra(localExtras);

        // 3. Load ad
        adView.loadAd();

        // 4. Add ad view to the UI
        binding.frameAdWrapper.addView(adView);
    }

    private ATBannerListener createListener() {
        return new ATBannerListener() {

            @Override
            public void onBannerLoaded() {

            }

            @Override
            public void onBannerFailed(AdError adError) {
                Log.e(TAG, "Ad loading failed: " + adError);
            }

            @Override
            public void onBannerClicked(ATAdInfo atAdInfo) {

            }

            @Override
            public void onBannerShow(ATAdInfo atAdInfo) {

            }

            @Override
            public void onBannerClose(ATAdInfo atAdInfo) {

            }

            @Override
            public void onBannerAutoRefreshed(ATAdInfo atAdInfo) {

            }

            @Override
            public void onBannerAutoRefreshFail(AdError adError) {
            }
        };
    }


}
