/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.topon;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.anythink.banner.api.ATBannerListener;
import com.anythink.banner.api.ATBannerView;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.sdk.api.adunits.AppstockInterstitialAdUnit;
import com.appstock.sdk.rendering.networking.urlBuilder.BidPathBuilder;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;

public class TopOnInterstitialBannerActivity extends BaseAdActivity {

    private static final String AD_UNIT_ID = "n1fskug7blk0q5";

    private ATInterstitial adUnit;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }


    private void createAd() {
        // 1. Create ad unit
        adUnit = new ATInterstitial(this, AD_UNIT_ID);

        // 2. Configure ad unit
        adUnit.setAdListener(createListener());

        // 3. Load ad
        adUnit.load();
    }

    private ATInterstitialListener createListener() {
        return new ATInterstitialListener() {
            @Override
            public void onInterstitialAdLoaded() {
                // 4. Show ad
                adUnit.show(TopOnInterstitialBannerActivity.this);
            }

            @Override
            public void onInterstitialAdLoadFail(AdError adError) {
                Log.e(TAG, "Ad loading failed: " + adError);
            }

            @Override
            public void onInterstitialAdClicked(ATAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdShow(ATAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdClose(ATAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdVideoStart(ATAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdVideoEnd(ATAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdVideoError(AdError adError) {

            }
        };
    }


}
