/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.activities.ads.topon;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.anythink.core.api.AdError;
import com.anythink.nativead.api.*;
import com.appstock.demo.java.R;
import com.appstock.demo.java.activities.BaseAdActivity;
import com.appstock.demo.java.utils.ImageUtils;
import com.appstock.sdk.api.adunits.nativead.request.*;
import com.appstock.sdk.api.adunits.nativead.response.NativeEventTracker;

import java.util.*;

public class TopOnNativeActivity extends BaseAdActivity {

    private static final String AD_UNIT_ID = "n1fskug7blk7jr";

    private ATNative adUnit;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }


    private void createAd() {
        // 1. Create ad unit
        adUnit = new ATNative(this, AD_UNIT_ID, createListener());

        // 2. Configure ad unit with native config
        HashMap<String, Object> localExtras = new HashMap<>();
        localExtras.put(AppstockNativeAdConfig.KEY_EXTRAS, createNativeConfig());
        adUnit.setLocalExtra(localExtras);

        // 3. Load ad
        adUnit.makeAdRequest();
    }

    private AppstockNativeAdConfig createNativeConfig() {
        ArrayList<NativeEventTracker.EventTrackingMethod> eventTrackingMethods = new ArrayList<>(
                Arrays.asList(
                        NativeEventTracker.EventTrackingMethod.IMAGE,
                        NativeEventTracker.EventTrackingMethod.JS
                )
        );
        NativeEventTracker eventTracker = new NativeEventTracker(
                NativeEventTracker.EventType.IMPRESSION,
                eventTrackingMethods
        );

        NativeTitleAsset title = new NativeTitleAsset();
        title.setLength(90);
        title.setRequired(true);

        NativeImageAsset icon = new NativeImageAsset(20, 20, 20, 20);
        icon.setImageType(NativeImageAsset.ImageType.ICON);
        icon.setRequired(true);

        NativeImageAsset mainImage = new NativeImageAsset(200, 200, 200, 200);
        mainImage.setImageType(NativeImageAsset.ImageType.MAIN);
        mainImage.setRequired(true);

        NativeDataAsset sponsored = new NativeDataAsset();
        sponsored.setLen(90);
        sponsored.setDataType(NativeDataAsset.DataType.SPONSORED);
        sponsored.setRequired(true);


        NativeDataAsset description = new NativeDataAsset();
        description.setDataType(NativeDataAsset.DataType.DESC);
        description.setRequired(true);

        NativeDataAsset ctaText = new NativeDataAsset();
        ctaText.setDataType(NativeDataAsset.DataType.CTATEXT);
        ctaText.setRequired(true);

        List<NativeAsset> assets = Arrays.asList(
                title,
                icon,
                mainImage,
                sponsored,
                description,
                ctaText
        );

        return new AppstockNativeAdConfig.Builder()
                .setContextType(NativeContextType.SOCIAL_CENTRIC)
                .setPlacementType(NativePlacementType.CONTENT_FEED)
                .setContextSubType(NativeContextSubtype.GENERAL_SOCIAL)
                .setNativeEventTrackers(Collections.singletonList(eventTracker))
                .setNativeAssets(assets)
                .build();
    }

    private void createNativeView(NativeAd ad) {
        if (ad == null) {
            Log.e(TAG, "Native ad is null. ");
            return;
        }

        ATNativeMaterial nativeAd = ad.getAdMaterial();
        ATNativeAdView templateRenderingView = new ATNativeAdView(this);
        templateRenderingView.setLayoutParams(new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        binding.groupRoot.addView(templateRenderingView);

        boolean notSelfRendering = ad.isNativeExpress();
        ATNativePrepareInfo prepareInfo = null;
        if (notSelfRendering) {
            ad.renderAdContainer(templateRenderingView, null);
        } else {
            prepareInfo = new ATNativePrepareInfo();
            createSelfRenderingAd(nativeAd, prepareInfo);
            ad.renderAdContainer(templateRenderingView, getContainerForAd());
        }
        ad.prepare(templateRenderingView, prepareInfo);
    }

    private void createSelfRenderingAd(ATNativeMaterial ad, ATNativePrepareInfo prepareInfo) {
        View nativeContainer = View.inflate(this, R.layout.layout_native, null);
        nativeContainer.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));

        ImageView icon = nativeContainer.findViewById(R.id.imgIcon);
        ImageUtils.download(ad.getIconImageUrl(), icon);
        prepareInfo.setIconView(icon);

        TextView title = nativeContainer.findViewById(R.id.tvTitle);
        title.setText(ad.getTitle());
        prepareInfo.setTitleView(title);

        ImageView image = nativeContainer.findViewById(R.id.imgImage);
        ImageUtils.download(ad.getMainImageUrl(), image);
        prepareInfo.setMainImageView(image);

        TextView description = nativeContainer.findViewById(R.id.tvDesc);
        description.setText(ad.getDescriptionText());
        prepareInfo.setDescView(description);

        Button cta = nativeContainer.findViewById(R.id.btnCta);
        cta.setText(ad.getCallToActionText());
        prepareInfo.setCtaView(cta);

        ArrayList<View> clickableViews = new ArrayList<>();
        clickableViews.add(icon);
        clickableViews.add(title);
        clickableViews.add(image);
        clickableViews.add(description);
        clickableViews.add(cta);
        prepareInfo.setClickViewList(clickableViews);

        getContainerForAd().addView(nativeContainer);
    }

    private ATNativeNetworkListener createListener() {
        return new ATNativeNetworkListener() {
            @Override
            public void onNativeAdLoaded() {
                createNativeView(adUnit.getNativeAd());
            }

            @Override
            public void onNativeAdLoadFail(AdError adError) {
                Log.e(TAG, "Ad loading failed: " + adError);
            }
        };
    }

}
