/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.java.testcases;


import com.appstock.demo.java.activities.ads.admob.*;
import com.appstock.demo.java.activities.ads.applovin.*;
import com.appstock.demo.java.activities.ads.inapp.*;
import com.appstock.demo.java.activities.ads.ironsource.IronSourceBannerActivity;
import com.appstock.demo.java.activities.ads.ironsource.IronSourceInterstitialActivity;
import com.appstock.demo.java.activities.ads.ironsource.IronSourceRewardedActivity;
import com.appstock.demo.java.activities.ads.topon.*;

import java.util.Arrays;
import java.util.List;

public class TestCaseRepository {

    public static TestCase lastTestCase;

    public static List<TestCase> getList() {
        List<TestCase> result = Arrays.asList(
                /* Appstock cases */
                new TestCase(
                        "Banner 300x250 (Appstock)",
                        AdFormat.DISPLAY_BANNER,
                        IntegrationKind.IN_APP,
                        AppstockBannerActivity.class
                ),
                new TestCase(
                        "Video Banner 300x250 (Appstock)",
                        AdFormat.VIDEO_BANNER,
                        IntegrationKind.IN_APP,
                        AppstockVideoBannerActivity.class
                ),
                new TestCase(
                        "Display Interstitial (Appstock)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.IN_APP,
                        AppstockInterstitialActivity.class
                ),
                new TestCase(
                        "Video Interstitial (Appstock)",
                        AdFormat.VIDEO_INTERSTITIAL,
                        IntegrationKind.IN_APP,
                        AppstockVideoInterstitialActivity.class
                ),
                new TestCase(
                        "Display Rewarded (Appstock)",
                        AdFormat.VIDEO_REWARDED,
                        IntegrationKind.IN_APP,
                        AppstockRewardedActivity.class
                ),
                new TestCase(
                        "Video Rewarded (Appstock)",
                        AdFormat.VIDEO_REWARDED,
                        IntegrationKind.IN_APP,
                        AppstockVideoRewardedActivity.class
                ),
                new TestCase(
                        "Native (Appstock)",
                        AdFormat.NATIVE,
                        IntegrationKind.IN_APP,
                        AppstockNativeActivity.class
                ),
                /* AdMob cases */
                new TestCase(
                        "Banner 300x250 (AdMob)",
                        AdFormat.DISPLAY_BANNER,
                        IntegrationKind.ADMOB,
                        AdMobBannerActivity.class
                ),
                new TestCase(
                        "Video Banner 300x250 (AdMob)",
                        AdFormat.VIDEO_BANNER,
                        IntegrationKind.ADMOB,
                        AdMobVideoBannerActivity.class
                ),
                new TestCase(
                        "Display Interstitial (AdMob)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.ADMOB,
                        AdMobInterstitialActivity.class
                ),
                new TestCase(
                        "Video Interstitial (AdMob)",
                        AdFormat.VIDEO_INTERSTITIAL,
                        IntegrationKind.ADMOB,
                        AdMobVideoInterstitialActivity.class
                ),
                new TestCase(
                        "Display Rewarded (AdMob)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.ADMOB,
                        AdMobRewardedActivity.class
                ),
                new TestCase(
                        "Video Rewarded (AdMob)",
                        AdFormat.VIDEO_INTERSTITIAL,
                        IntegrationKind.ADMOB,
                        AdMobVideoRewardedActivity.class
                ),
                new TestCase(
                        "Native (AdMob)",
                        AdFormat.NATIVE,
                        IntegrationKind.ADMOB,
                        AdMobNativeActivity.class
                ),
                /* AppLovin cases */
                new TestCase(
                        "Banner 300x250 (AppLovin)",
                        AdFormat.DISPLAY_BANNER,
                        IntegrationKind.APPLOVIN,
                        AppLovinBannerActivity.class
                ),
                new TestCase(
                        "Video Banner 300x250 (AppLovin)",
                        AdFormat.VIDEO_BANNER,
                        IntegrationKind.APPLOVIN,
                        AppLovinVideoBannerActivity.class
                ),
                new TestCase(
                        "Display Interstitial (AppLovin)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.APPLOVIN,
                        AppLovinInterstitialActivity.class
                ),
                new TestCase(
                        "Video Interstitial (AppLovin)",
                        AdFormat.VIDEO_INTERSTITIAL,
                        IntegrationKind.APPLOVIN,
                        AppLovinVideoInterstitialActivity.class
                ),
                new TestCase(
                        "Display Rewarded (AppLovin)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.APPLOVIN,
                        AppLovinRewardedActivity.class
                ),
                new TestCase(
                        "Video Rewarded (AppLovin)",
                        AdFormat.VIDEO_INTERSTITIAL,
                        IntegrationKind.APPLOVIN,
                        AppLovinVideoRewardedActivity.class
                ),
                new TestCase(
                        "Native (AppLovin)",
                        AdFormat.NATIVE,
                        IntegrationKind.APPLOVIN,
                        AppLovinNativeActivity.class
                ),
                /* TopOn cases */
                new TestCase(
                        "Banner 320x50 (TopOn)",
                        AdFormat.DISPLAY_BANNER,
                        IntegrationKind.TOPON,
                        TopOnBannerActivity.class
                ),
                new TestCase(
                        "Video Banner 300x250 (TopOn)",
                        AdFormat.DISPLAY_BANNER,
                        IntegrationKind.TOPON,
                        TopOnBannerVideoActivity.class
                ),
                new TestCase(
                        "Display Interstitial (TopOn)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.TOPON,
                        TopOnInterstitialBannerActivity.class
                ),
                new TestCase(
                        "Video Interstitial (TopOn)",
                        AdFormat.VIDEO_INTERSTITIAL,
                        IntegrationKind.TOPON,
                        TopOnInterstitialVideoActivity.class
                ),
                new TestCase(
                        "Native (TopOn)",
                        AdFormat.NATIVE,
                        IntegrationKind.TOPON,
                        TopOnNativeActivity.class
                ),
                /* IronSource cases */
                new TestCase(
                        "Banner (IronSource)",
                        AdFormat.DISPLAY_BANNER,
                        IntegrationKind.IRONSOURCE,
                        IronSourceBannerActivity.class
                ),
                new TestCase(
                        "Interstitial (IronSource)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.IRONSOURCE,
                        IronSourceInterstitialActivity.class
                ),
                new TestCase(
                        "Rewarded (IronSource)",
                        AdFormat.DISPLAY_INTERSTITIAL,
                        IntegrationKind.IRONSOURCE,
                        IronSourceRewardedActivity.class
                )
        );
        return result;
    }

}
