/* 
 *  © 2024 Appstock 
 *  */

plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
    id("kotlin-kapt")
}

android {
    namespace = "com.appstock.demo.kotlin"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.appstock.demo.kotlin"
        minSdk = 21
        targetSdk = 34
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
    buildFeatures {
        dataBinding = true
    }
}

dependencies {
    implementation("com.appstock:appstock-sdk:1.1.1")
    implementation("com.appstock:appstock-sdk-google-mobile-ads-adapters:1.1.1")
    implementation("com.appstock:appstock-sdk-applovin-adapters:1.1.1")
    implementation("com.appstock:appstock-sdk-topon-adapters:1.1.1")
    implementation("com.appstock:appstock-sdk-ironsource-adapters:1.1.1")

    // Default
    implementation("androidx.core:core-ktx:1.13.1")
    implementation("androidx.appcompat:appcompat:1.6.1")
    implementation("com.google.android.material:material:1.12.0")
    implementation("androidx.preference:preference-ktx:1.2.1")

    // Google ads
    implementation("com.google.android.gms:play-services-ads:23.0.0")

    // Applovin Max ads
    implementation("com.applovin:applovin-sdk:12.4.3")

    // TopOn ads
    implementation("com.anythink.sdk:core-tpn:6.3.76")
    implementation("com.anythink.sdk:nativead-tpn:6.3.76")
    implementation("com.anythink.sdk:banner-tpn:6.3.76")
    implementation("com.anythink.sdk:interstitial-tpn:6.3.76")
    implementation("com.anythink.sdk:rewardedvideo-tpn:6.3.76")
    implementation("com.anythink.sdk:splash-tpn:6.3.76")
    implementation("androidx.appcompat:appcompat:1.1.0")
    implementation("androidx.browser:browser:1.4.0")
    implementation("com.anythink.sdk:tramini-plugin-tpn:6.3.76")

    // IronSource
    implementation("com.ironsource.sdk:mediationsdk:8.3.0")
    implementation("com.ironsource:adqualitysdk:7.20.5")
    implementation("com.google.android.gms:play-services-appset:16.0.0")
    implementation("com.google.android.gms:play-services-ads-identifier:18.0.1")
    implementation("com.google.android.gms:play-services-basement:18.1.0")


    // Image Downloader
    implementation("com.github.bumptech.glide:glide:4.14.2")

    // Tests
    testImplementation("junit:junit:4.13.2")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
}
