/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin

import android.app.Application
import android.util.Log
import com.anythink.core.api.ATSDK
import com.applovin.sdk.AppLovinMediationProvider
import com.applovin.sdk.AppLovinSdk
import com.applovin.sdk.AppLovinSdkInitializationConfiguration
import com.google.android.gms.ads.MobileAds
import com.ironsource.mediationsdk.IronSource
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo
import com.ironsource.mediationsdk.logger.IronSourceError
import com.ironsource.mediationsdk.model.Placement
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener
import com.appstock.demo.kotlin.utils.Settings
import com.appstock.sdk.api.Appstock

class TheApplication : Application() {

    override fun onCreate() {
        super.onCreate()
        initAppstockSdk()
        initAdMob()
        initApplovinMax()
        initTopOn()
        initIronSource()
        Settings.init(this)
    }

    private fun initAppstockSdk() {
        // WL_CHANGE
        Appstock.initializeSdk(this, "appstock-demo")
    }

    private fun initAdMob() {
        MobileAds.initialize(this)
    }

    private fun initApplovinMax() {
        val initConfig = AppLovinSdkInitializationConfiguration
            .builder(
                "1tLUnP4cVQqpHuHH2yMtfdESvvUhTB05NdbCoDTceDDNVnhd_T8kwIzXDN9iwbdULTboByF-TtNaiTmsoVbxZw",
                this
            )
            .setMediationProvider(AppLovinMediationProvider.MAX)
            .build()

        AppLovinSdk.getInstance(this).initialize(initConfig) {
            Log.d("ApplovinInitialization", "Initialization result: $it")
        }
    }

    private fun initTopOn() {
        ATSDK.init(this, "h66dacef4f35df", "5c591f747ce5992032eaffa7913f3109")
    }

    private fun initIronSource() {
        IronSource.setLevelPlayRewardedVideoManualListener(object : LevelPlayRewardedVideoManualListener {
            override fun onAdOpened(p0: AdInfo?) {}

            override fun onAdShowFailed(p0: IronSourceError?, p1: AdInfo?) {}

            override fun onAdClicked(p0: Placement?, p1: AdInfo?) {}

            override fun onAdRewarded(p0: Placement?, p1: AdInfo?) {}

            override fun onAdClosed(p0: AdInfo?) {}

            override fun onAdReady(p0: AdInfo?) {}

            override fun onAdLoadFailed(p0: IronSourceError?) {}
        })
        IronSource.init(this, "24f2f5e8d")
    }

}