/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin.activities

import android.os.Bundle
import android.view.ViewGroup
import androidx.annotation.CallSuper
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import com.appstock.demo.kotlin.R
import com.appstock.demo.kotlin.databinding.ActivityDemoBinding
import com.appstock.demo.kotlin.testcases.TestCase
import com.appstock.demo.kotlin.testcases.TestCaseRepository

open class BaseAdActivity : AppCompatActivity() {

    companion object {
        const val TAG = "AdExampleActivity"
    }

    /**
     * ViewGroup container for any ad view.
     */
    protected val containerForAd: ViewGroup
        get() = binding.frameAdWrapper

    protected lateinit var binding: ActivityDemoBinding
    private var testCase: TestCase = TestCaseRepository.lastTestCase

    @CallSuper
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_demo)
        binding.tvTestCaseName.text = testCase.name
    }

}