/* 
 *  © 2024 Appstock 
 *  */
package com.appstock.demo.kotlin.activities.ads.admob

import android.app.Activity
import android.os.Bundle
import android.util.Log
import com.google.android.gms.ads.*
import com.google.android.gms.ads.rewarded.RewardItem
import com.google.android.gms.ads.rewarded.RewardedAd
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.sdk.admob.AppstockGadMediationAdapter

class AdMobVideoRewardedActivity : BaseAdActivity() {

    public override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    private fun createAd() {
        // 1. Create ad request with AppstockGadMediationAdapter
        val adRequest = AdRequest.Builder()
            .addNetworkExtrasBundle(AppstockGadMediationAdapter::class.java, Bundle())
            .build()

        // 2. Load ad
        RewardedAd.load(
            this, ADMOB_AD_UNIT_ID, adRequest, createLoadingListener(
                this
            )
        )
    }

    companion object {
        private const val ADMOB_AD_UNIT_ID = "ca-app-pub-2844566227051243/5052750851"

        private fun createLoadingListener(activity: Activity): RewardedAdLoadCallback {
            return object : RewardedAdLoadCallback() {
                override fun onAdLoaded(adUnit: RewardedAd) {
                    super.onAdLoaded(adUnit)
                    Log.d(TAG, "Ad loaded successfully")
                    adUnit.fullScreenContentCallback = createAdListener()

                    // 3. Show ad
                    adUnit.show(activity, createRewardListener())
                }

                override fun onAdFailedToLoad(loadAdError: LoadAdError) {
                    Log.e(TAG, "Ad failed to load: $loadAdError")
                }
            }
        }

        private fun createRewardListener(): OnUserEarnedRewardListener {
            return OnUserEarnedRewardListener { rewardItem: RewardItem ->
                Log.d(
                    TAG,
                    "User earned reward: " + rewardItem.type + " " + rewardItem.amount
                )
            }
        }


        private fun createAdListener(): FullScreenContentCallback {
            return object : FullScreenContentCallback() {
                override fun onAdShowedFullScreenContent() {
                    super.onAdShowedFullScreenContent()
                    Log.d(TAG, "Full screen ad displayed")
                }

                override fun onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent()
                    Log.d(TAG, "Full screen ad closed")
                }

                override fun onAdFailedToShowFullScreenContent(adError: AdError) {
                    super.onAdFailedToShowFullScreenContent(adError)
                    Log.e(TAG, "Failed to show ad: " + adError.message)
                }
            }
        }
    }
}
