/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin.activities.ads.applovin

import android.os.Bundle
import android.util.Log
import android.view.ViewGroup
import com.applovin.mediation.MaxAd
import com.applovin.mediation.MaxError
import com.applovin.mediation.nativeAds.MaxNativeAdListener
import com.applovin.mediation.nativeAds.MaxNativeAdLoader
import com.applovin.mediation.nativeAds.MaxNativeAdView
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder
import com.appstock.demo.kotlin.R
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.sdk.api.adunits.nativead.request.*
import com.appstock.sdk.api.adunits.nativead.response.NativeEventTracker
import java.util.*

class AppLovinNativeActivity : BaseAdActivity() {

    private var appLovinLoader: MaxNativeAdLoader? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        if (appLovinLoader != null) {
            appLovinLoader!!.destroy()
        }
    }


    private fun createAd() {
        // 1. Create MaxNativeAdLoader
        appLovinLoader = MaxNativeAdLoader(APP_LOVIN_AD_UNIT_ID, this)
        appLovinLoader?.setNativeAdListener(createListener(containerForAd))

        // 2. Create native ad config and set it to local extras
        val nativeAdConfig = createNativeConfig()
        appLovinLoader?.setLocalExtraParameter(AppstockNativeAdConfig.KEY_EXTRAS, nativeAdConfig)

        // 3. Create custom native view
        val adView = createCustomView()

        // 4. Load ad
        appLovinLoader?.loadAd(adView)
    }


    private fun createNativeConfig(): AppstockNativeAdConfig {
        val eventTrackingMethods = ArrayList(
            Arrays.asList(
                NativeEventTracker.EventTrackingMethod.IMAGE,
                NativeEventTracker.EventTrackingMethod.JS
            )
        )
        val eventTracker = NativeEventTracker(
            NativeEventTracker.EventType.IMPRESSION,
            eventTrackingMethods
        )

        val title = NativeTitleAsset()
        title.setLength(90)
        title.isRequired = true

        val icon = NativeImageAsset(20, 20, 20, 20)
        icon.imageType = NativeImageAsset.ImageType.ICON
        icon.isRequired = true

        val mainImage = NativeImageAsset(200, 200, 200, 200)
        mainImage.imageType = NativeImageAsset.ImageType.MAIN
        mainImage.isRequired = true

        val sponsored = NativeDataAsset()
        sponsored.len = 90
        sponsored.dataType = NativeDataAsset.DataType.SPONSORED
        sponsored.isRequired = true


        val description = NativeDataAsset()
        description.dataType = NativeDataAsset.DataType.DESC
        description.isRequired = true

        val ctaText = NativeDataAsset()
        ctaText.dataType = NativeDataAsset.DataType.CTATEXT
        ctaText.isRequired = true

        val assets = Arrays.asList(
            title,
            icon,
            mainImage,
            sponsored,
            description,
            ctaText
        )

        return AppstockNativeAdConfig.Builder()
            .setContextType(NativeContextType.SOCIAL_CENTRIC)
            .setPlacementType(NativePlacementType.CONTENT_FEED)
            .setContextSubType(NativeContextSubtype.GENERAL_SOCIAL)
            .setNativeEventTrackers(listOf(eventTracker))
            .setNativeAssets(assets)
            .build()
    }

    private fun createCustomView(): MaxNativeAdView {
        val builder: MaxNativeAdViewBinder = MaxNativeAdViewBinder.Builder(R.layout.view_native_ad_max)
            .setTitleTextViewId(R.id.tvHeadline)
            .setBodyTextViewId(R.id.tvBody)
            .setIconImageViewId(R.id.imgIco)
            .setMediaContentViewGroupId(R.id.frameMedia)
            .setCallToActionButtonId(R.id.btnCallToAction)
            .build()

        val adView = MaxNativeAdView(builder, this)
        return adView
    }

    companion object {
        private const val APP_LOVIN_AD_UNIT_ID = "f6a79129fe85a564"

        private fun createListener(containerForAd: ViewGroup): MaxNativeAdListener {
            return object : MaxNativeAdListener() {
                override fun onNativeAdLoaded(maxNativeAdView: MaxNativeAdView?, maxAd: MaxAd) {
                    super.onNativeAdLoaded(maxNativeAdView, maxAd)

                    // 5. Show ad
                    containerForAd.removeAllViews()
                    containerForAd.addView(maxNativeAdView)
                }

                override fun onNativeAdLoadFailed(s: String, maxError: MaxError) {
                    Log.e(TAG, "Can't download native ad: " + maxError.message)
                }
            }
        }
    }
}