/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin.activities.ads.inapp

import android.os.Bundle
import android.util.Log
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.sdk.api.adunits.AppstockAdView
import com.appstock.sdk.api.adunits.AppstockAdViewListener
import com.appstock.sdk.api.adunits.utils.AppstockAdException
import com.appstock.sdk.api.AdInfo
import com.appstock.sdk.api.adunits.utils.AppstockAdSize

class AppstockBannerActivity : BaseAdActivity() {

    private var adView: AppstockAdView? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        adView?.destroy()
    }


    private fun createAd() {
        // 1. Create AppstockAdView
        val adView = AppstockAdView(this).also { this.adView = it }

        // 2. Configure ad unit
        adView.setPlacementId(PLACEMENT_ID)
        adView.setAdSizes(AppstockAdSize(WIDTH, HEIGHT))
        adView.setAdViewListener(createListener())
        adView.autoRefreshDelay = 30

        // 3. Load ad
        adView.loadAd()

        // 4. Add AppstockAdView to the app UI
        containerForAd.addView(adView)
    }

    companion object {
        private const val PLACEMENT_ID = "4"
        private const val WIDTH = 300
        private const val HEIGHT = 250

        private fun createListener(): AppstockAdViewListener {
            return object : AppstockAdViewListener {
                override fun onAdLoaded(AppstockAdView: AppstockAdView, adInfo: AdInfo) {
                    // Called when ad loaded
                    Log.d(TAG, "Ad loaded successfully")
                }

                override fun onAdFailed(AppstockAdView: AppstockAdView, e: AppstockAdException) {
                    // Called when ad failed to load or parse
                    Log.e(TAG, "Ad failed to load: " + e.message)
                }

                override fun onAdDisplayed(AppstockAdView: AppstockAdView) {
                    // Called when ad displayed
                }

                override fun onAdClicked(AppstockAdView: AppstockAdView) {
                    // Called when ad clicked
                }

                override fun onAdClosed(AppstockAdView: AppstockAdView) {
                    // Called when ad closed
                }
            }
        }
    }

}
