/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin.activities.ads.inapp

import android.os.Bundle
import android.util.Log
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.sdk.api.adunits.AppstockInterstitialAdUnit
import com.appstock.sdk.api.adunits.AppstockInterstitialAdUnitListener
import com.appstock.sdk.api.AdInfo
import com.appstock.sdk.api.adunits.utils.AppstockAdException

class AppstockInterstitialActivity : BaseAdActivity() {

    private var adUnit: AppstockInterstitialAdUnit? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        if (adUnit != null) {
            adUnit?.destroy()
        }
    }

    private fun createAd() {
        // 1. Create AppstockInterstitialAdUnit
        adUnit = AppstockInterstitialAdUnit(this)

        // 2. Configure ad unit
        adUnit?.setPlacementId(PLACEMENT_ID)
        adUnit?.setInterstitialAdUnitListener(createListener())

        // 3. Load ad
        adUnit?.loadAd()
    }

    companion object {
        private const val PLACEMENT_ID = "5"

        private fun createListener(): AppstockInterstitialAdUnitListener {
            return object : AppstockInterstitialAdUnitListener {
                override fun onAdLoaded(adUnit: AppstockInterstitialAdUnit, adInfo: AdInfo) {
                    // Called when ad loaded
                    Log.d(TAG, "Ad loaded successfully")

                    // 4. Show ad
                    adUnit.show()
                }

                override fun onAdDisplayed(adUnit: AppstockInterstitialAdUnit) {
                    // Called when ad displayed full screen
                    Log.d(TAG, "Ad displayed")
                }

                override fun onAdFailed(
                    adUnit: AppstockInterstitialAdUnit,
                    e: AppstockAdException,
                ) {
                    // Called when ad failed to load or parse
                    Log.e(TAG, "Ad failed to load: " + e.message)
                }

                override fun onAdClicked(adUnit: AppstockInterstitialAdUnit) {
                    // Called when ad clicked
                }

                override fun onAdClosed(adUnit: AppstockInterstitialAdUnit) {
                    // Called when ad closed
                }
            }
        }
    }
}