/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin.activities.ads.inapp

import android.os.Bundle
import android.util.Log
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.sdk.api.adunits.AppstockAdView
import com.appstock.sdk.api.adunits.AppstockAdViewListener
import com.appstock.sdk.api.AdInfo
import com.appstock.sdk.api.adunits.AppstockAdViewVideoListener
import com.appstock.sdk.api.adunits.utils.AppstockAdException
import com.appstock.sdk.api.adunits.utils.AppstockAdSize
import com.appstock.sdk.api.adunits.utils.AppstockAdUnitFormat
import com.appstock.sdk.api.adunits.utils.AppstockVideoPlacementType

class AppstockVideoBannerActivity : BaseAdActivity() {

    private var adView: AppstockAdView? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        adView?.destroy()
    }


    private fun createAd() {
        // 1. Create AppstockAdView
        val adView = AppstockAdView(this).also { this.adView = it }

        // 2. Configure ad unit
        adView.setPlacementId(PLACEMENT_ID)
        adView.setAdSizes(AppstockAdSize(WIDTH, HEIGHT))
        adView.setAdViewListener(createListener())
        adView.setVideoAdListener(createVideoListener())
        adView.setAdUnitFormat(AppstockAdUnitFormat.VIDEO)
        adView.videoPlacementType = AppstockVideoPlacementType.IN_BANNER
        adView.autoRefreshDelay = 30

        // 3. Load ad
        adView.loadAd()

        // 4. Add AppstockAdView to the app UI
        containerForAd.addView(adView)
    }

    companion object {
        private const val PLACEMENT_ID = "8"
        private const val WIDTH = 300
        private const val HEIGHT = 250

        private fun createListener(): AppstockAdViewListener {
            return object : AppstockAdViewListener {
                override fun onAdLoaded(AppstockAdView: AppstockAdView, adInfo: AdInfo) {
                    // Called when ad loaded
                    Log.d(TAG, "Ad loaded successfully")
                }

                override fun onAdFailed(AppstockAdView: AppstockAdView, e: AppstockAdException) {
                    // Called when ad failed to load or parse
                    Log.e(TAG, "Ad failed to load: " + e.message)
                }

                override fun onAdDisplayed(AppstockAdView: AppstockAdView) {
                    // Called when ad displayed
                }

                override fun onAdClicked(AppstockAdView: AppstockAdView) {
                    // Called when ad clicked
                }

                override fun onAdClosed(AppstockAdView: AppstockAdView) {
                    // Called when ad closed
                }
            }
        }

        private fun createVideoListener(): AppstockAdViewVideoListener {
            return object : AppstockAdViewVideoListener {
                override fun onVideoCompleted(AppstockAdView: AppstockAdView) {
                    // Called when video completed
                    Log.d(TAG, "Video completed")
                }

                override fun onVideoPaused(AppstockAdView: AppstockAdView) {
                    // Called when video paused
                }

                override fun onVideoResumed(AppstockAdView: AppstockAdView) {
                    // Called when video resumed
                }

                override fun onVideoUnMuted(AppstockAdView: AppstockAdView) {
                    // Called when video unmuted
                }

                override fun onVideoMuted(AppstockAdView: AppstockAdView) {
                    // Called when video muted
                }
            }
        }

    }

}
