/* 
 *  © 2024 Appstock 
 *  */
package com.appstock.demo.kotlin.activities.ads.inapp

import android.os.Bundle
import android.util.Log
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.sdk.api.adunits.AppstockRewardedAdUnit
import com.appstock.sdk.api.adunits.AppstockRewardedAdUnitListener
import com.appstock.sdk.api.adunits.utils.AppstockAdException
import com.appstock.sdk.api.AdInfo
import com.appstock.sdk.rendering.bidding.data.bid.rewarded.Reward

class AppstockVideoRewardedActivity : BaseAdActivity() {
    
    private var adUnit: AppstockRewardedAdUnit? = null

    public override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        adUnit?.destroy()
    }


    private fun createAd() {
        // 1. Create ad unit
        adUnit = AppstockRewardedAdUnit(this)

        // 2. Configure ad unit
        adUnit?.setPlacementId(PLACEMENT_ID)
        adUnit?.setRewardedAdUnitListener(createListener())

        // 3. Load ad
        adUnit?.loadAd()
    }

    companion object {
        private const val PLACEMENT_ID = "16"

        private fun createListener(): AppstockRewardedAdUnitListener {
            return object : AppstockRewardedAdUnitListener {
                override fun onAdLoaded(adUnit: AppstockRewardedAdUnit, adInfo: AdInfo) {
                    // Called when ad loaded
                    Log.d(TAG, "Ad loaded successfully")

                    // 4. Show ad
                    adUnit.show()
                }

                override fun onReward(adUnit: AppstockRewardedAdUnit, reward: Reward?) {
                    if (reward == null) {
                        Log.d(TAG, "User earned empty reward!")
                        return
                    }
                    // Called when user earned reward
                    Log.d(TAG, "User earned reward: " + reward.count + " " + reward.type)
                }

                override fun onAdDisplayed(adUnit: AppstockRewardedAdUnit) {
                    // Called when ad displayed full screen
                    Log.d(TAG, "Ad displayed")
                }

                override fun onAdFailed(adUnit: AppstockRewardedAdUnit, e: AppstockAdException) {
                    // Called when ad failed to load
                    Log.e(TAG, "Ad failed to load: " + e.message)
                }

                override fun onAdClicked(adUnit: AppstockRewardedAdUnit) {
                    // Called when ad clicked
                }

                override fun onAdClosed(adUnit: AppstockRewardedAdUnit) {
                    // Called when ad closed
                }
            }
        }
    }
}
