package com.appstock.demo.kotlin.activities.ads.ironsource


import android.os.Bundle
import android.util.Log
import android.view.ViewGroup
import com.ironsource.mediationsdk.ISBannerSize
import com.ironsource.mediationsdk.IronSource
import com.ironsource.mediationsdk.IronSourceBannerLayout
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo
import com.ironsource.mediationsdk.logger.IronSourceError
import com.ironsource.mediationsdk.sdk.LevelPlayBannerListener
import com.appstock.demo.kotlin.activities.BaseAdActivity

class IronSourceBannerActivity : BaseAdActivity() {

    private var adView: IronSourceBannerLayout? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onResume() {
        super.onResume()
        IronSource.onResume(this)
    }

    override fun onPause() {
        super.onPause()
        IronSource.onPause(this)
    }

    override fun onDestroy() {
        super.onDestroy()
        IronSource.destroyBanner(adView)
    }


    private fun createAd() {
        // 1. Create ad view
        adView = IronSource.createBanner(this, ISBannerSize(WIDTH, HEIGHT))

        // 2. Configure ad view
        adView?.setLevelPlayBannerListener(createListener())
        adView?.setLayoutParams(
            ViewGroup.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                (getResources().getDisplayMetrics().density * HEIGHT).toInt()
            )
        )

        // 3. Load ad
        IronSource.loadBanner(adView)

        // 4. Add ad view to the UI
        binding.frameAdWrapper.addView(adView)
    }

    companion object {
        private const val WIDTH = 300
        private const val HEIGHT = 250

        private fun createListener(): LevelPlayBannerListener {
            return object : LevelPlayBannerListener {
                override fun onAdLoaded(adInfo: AdInfo?) {
                }

                override fun onAdLoadFailed(error: IronSourceError) {
                    Log.e(TAG, "Ad loading failed: $error")
                }

                override fun onAdClicked(adInfo: AdInfo?) {
                }

                override fun onAdLeftApplication(adInfo: AdInfo?) {
                }

                override fun onAdScreenPresented(adInfo: AdInfo?) {
                }

                override fun onAdScreenDismissed(adInfo: AdInfo?) {
                }
            }
        }
    }
}
