package com.appstock.demo.kotlin.activities.ads.ironsource


import android.os.Bundle
import android.util.Log
import com.ironsource.mediationsdk.IronSource
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo
import com.ironsource.mediationsdk.logger.IronSourceError
import com.ironsource.mediationsdk.sdk.LevelPlayInterstitialListener
import com.appstock.demo.kotlin.activities.BaseAdActivity


class IronSourceInterstitialActivity : BaseAdActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    private fun createAd() {
        // 1. Load ad
        IronSource.setLevelPlayInterstitialListener(createListener())
        IronSource.loadInterstitial()
    }

    companion object {
        private fun createListener(): LevelPlayInterstitialListener {
            return object : LevelPlayInterstitialListener {
                override fun onAdReady(adInfo: AdInfo) {
                    // 2. Show ad
                    IronSource.showInterstitial()
                }

                override fun onAdLoadFailed(error: IronSourceError) {
                    Log.e(TAG, "Ad loading failed: $error")
                }

                override fun onAdOpened(adInfo: AdInfo) {
                }

                override fun onAdShowSucceeded(adInfo: AdInfo) {
                }

                override fun onAdShowFailed(ironSourceError: IronSourceError, adInfo: AdInfo) {
                }

                override fun onAdClicked(adInfo: AdInfo) {
                }

                override fun onAdClosed(adInfo: AdInfo) {
                }
            }
        }
    }
}
