package com.appstock.demo.kotlin.activities.ads.ironsource


import android.os.Bundle
import android.util.Log
import com.ironsource.mediationsdk.IronSource
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo
import com.ironsource.mediationsdk.logger.IronSourceError
import com.ironsource.mediationsdk.model.Placement
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener
import com.appstock.demo.kotlin.activities.BaseAdActivity


class IronSourceRewardedActivity : BaseAdActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    private fun createAd() {
        // 1. Load ad
        IronSource.setLevelPlayRewardedVideoManualListener(createListener())
        IronSource.loadRewardedVideo()
    }

    companion object {
        private fun createListener(): LevelPlayRewardedVideoManualListener {
            return object : LevelPlayRewardedVideoManualListener {
                override fun onAdReady(adInfo: AdInfo) {
                    // 2. Show ad
                    IronSource.showRewardedVideo()
                }

                override fun onAdLoadFailed(error: IronSourceError) {
                    Log.e(TAG, "Ad loading failed: $error")
                }

                override fun onAdOpened(adInfo: AdInfo) {}
                override fun onAdShowFailed(ironSourceError: IronSourceError, adInfo: AdInfo) {}
                override fun onAdClicked(p0: Placement?, p1: AdInfo?) {}
                override fun onAdRewarded(p0: Placement?, p1: AdInfo?) {}
                override fun onAdClosed(adInfo: AdInfo) {}
            }
        }
    }
}
