/* 
 *  © 2024 Appstock 
 *  */
package com.appstock.demo.kotlin.activities.ads.topon

import android.os.Bundle
import android.util.Log
import android.view.ViewGroup
import android.widget.FrameLayout
import com.anythink.banner.api.ATBannerListener
import com.anythink.banner.api.ATBannerView
import com.anythink.core.api.ATAdConst
import com.anythink.core.api.ATAdInfo
import com.anythink.core.api.AdError
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.demo.kotlin.activities.ads.topon.TopOnBannerActivity.Companion
import com.appstock.sdk.topon.AppstockBannerAdapter

class TopOnBannerVideoActivity : BaseAdActivity() {
    private var adView: ATBannerView? = null

    public override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        if (adView != null) {
            adView!!.destroy()
        }
    }


    private fun createAd() {
        // 1. Create ad view
        val adView = ATBannerView(this).also { adView = it }

        // 2. Configure ad view
        adView.setPlacementId(AD_UNIT_ID)
        adView.layoutParams =
            FrameLayout.LayoutParams(
                resources.displayMetrics.widthPixels,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
        adView.setBannerAdListener(createListener())

        // Set sizes for TopOn banner and for Appstock banner
        val localExtras = HashMap<String, Any>()
        localExtras[ATAdConst.KEY.AD_WIDTH] = resources.displayMetrics.widthPixels
        localExtras[ATAdConst.KEY.AD_HEIGHT] = HEIGHT * resources.displayMetrics.density
        localExtras[AppstockBannerAdapter.KEY_WIDTH] = WIDTH
        localExtras[AppstockBannerAdapter.KEY_HEIGHT] = HEIGHT
        adView.setLocalExtra(localExtras)

        // 3. Load ad
        adView.loadAd()

        // 4. Add ad view to the UI
        containerForAd.addView(adView)
    }

    private fun createListener(): ATBannerListener {
        return object : ATBannerListener {
            override fun onBannerLoaded() {
            }

            override fun onBannerFailed(adError: AdError) {
                Log.e(TAG, "Ad loading failed: $adError")
            }

            override fun onBannerClicked(atAdInfo: ATAdInfo) {
            }

            override fun onBannerShow(atAdInfo: ATAdInfo) {
            }

            override fun onBannerClose(atAdInfo: ATAdInfo) {
            }

            override fun onBannerAutoRefreshed(atAdInfo: ATAdInfo) {
            }

            override fun onBannerAutoRefreshFail(adError: AdError) {
            }
        }
    }


    companion object {
        private const val WIDTH = 300
        private const val HEIGHT = 250
        private const val AD_UNIT_ID = "n66db01fe38055"
    }
}
