/* 
 *  © 2024 Appstock 
 *  */
package com.appstock.demo.kotlin.activities.ads.topon

import android.os.Bundle
import android.util.Log
import com.anythink.core.api.ATAdInfo
import com.anythink.core.api.AdError
import com.anythink.interstitial.api.ATInterstitial
import com.anythink.interstitial.api.ATInterstitialListener
import com.appstock.demo.kotlin.activities.BaseAdActivity

class TopOnInterstitialVideoActivity : BaseAdActivity() {
    private var adUnit: ATInterstitial? = null

    public override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }


    private fun createAd() {
        // 1. Create ad unit
        val adUnit = ATInterstitial(this, AD_UNIT_ID).also { adUnit = it }

        // 2. Configure ad unit
        adUnit.setAdListener(createListener())

        // 3. Load ad
        adUnit.load()
    }

    private fun createListener(): ATInterstitialListener {
        return object : ATInterstitialListener {
            override fun onInterstitialAdLoaded() {
                // 4. Show ad
                adUnit?.show(this@TopOnInterstitialVideoActivity)
            }

            override fun onInterstitialAdLoadFail(adError: AdError) {
                Log.e(TAG, "Ad loading failed: $adError")
            }

            override fun onInterstitialAdClicked(atAdInfo: ATAdInfo) {
            }

            override fun onInterstitialAdShow(atAdInfo: ATAdInfo) {
            }

            override fun onInterstitialAdClose(atAdInfo: ATAdInfo) {
            }

            override fun onInterstitialAdVideoStart(atAdInfo: ATAdInfo) {
            }

            override fun onInterstitialAdVideoEnd(atAdInfo: ATAdInfo) {
            }

            override fun onInterstitialAdVideoError(adError: AdError) {
            }
        }
    }


    companion object {
        private const val AD_UNIT_ID = "n1fskug7blk40o"
    }
}
