/* 
 *  © 2024 Appstock 
 *  */
package com.appstock.demo.kotlin.activities.ads.topon

import android.os.Bundle
import android.util.Log
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.anythink.core.api.AdError
import com.anythink.nativead.api.*
import com.appstock.demo.kotlin.R
import com.appstock.demo.kotlin.activities.BaseAdActivity
import com.appstock.demo.kotlin.utils.ImageUtils.download
import com.appstock.sdk.api.adunits.nativead.request.*
import com.appstock.sdk.api.adunits.nativead.response.NativeEventTracker
import java.util.*

class TopOnNativeActivity : BaseAdActivity() {
    private var adUnit: ATNative? = null

    public override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }


    private fun createAd() {
        // 1. Create ad unit
        val adUnit = ATNative(this, AD_UNIT_ID, createListener()).also { adUnit = it }

        // 2. Configure ad unit with native config
        val localExtras = HashMap<String, Any>()
        localExtras[AppstockNativeAdConfig.KEY_EXTRAS] = createNativeConfig()
        adUnit.setLocalExtra(localExtras)

        // 3. Load ad
        adUnit.makeAdRequest()
    }

    private fun createNativeConfig(): AppstockNativeAdConfig {
        val eventTrackingMethods = ArrayList(
            Arrays.asList(
                NativeEventTracker.EventTrackingMethod.IMAGE,
                NativeEventTracker.EventTrackingMethod.JS
            )
        )
        val eventTracker = NativeEventTracker(
            NativeEventTracker.EventType.IMPRESSION,
            eventTrackingMethods
        )

        val title = NativeTitleAsset()
        title.setLength(90)
        title.isRequired = true

        val icon = NativeImageAsset(20, 20, 20, 20)
        icon.imageType = NativeImageAsset.ImageType.ICON
        icon.isRequired = true

        val mainImage = NativeImageAsset(200, 200, 200, 200)
        mainImage.imageType = NativeImageAsset.ImageType.MAIN
        mainImage.isRequired = true

        val sponsored = NativeDataAsset()
        sponsored.len = 90
        sponsored.dataType = NativeDataAsset.DataType.SPONSORED
        sponsored.isRequired = true


        val description = NativeDataAsset()
        description.dataType = NativeDataAsset.DataType.DESC
        description.isRequired = true

        val ctaText = NativeDataAsset()
        ctaText.dataType = NativeDataAsset.DataType.CTATEXT
        ctaText.isRequired = true

        val assets = Arrays.asList(
            title,
            icon,
            mainImage,
            sponsored,
            description,
            ctaText
        )

        return AppstockNativeAdConfig.Builder()
            .setContextType(NativeContextType.SOCIAL_CENTRIC)
            .setPlacementType(NativePlacementType.CONTENT_FEED)
            .setContextSubType(NativeContextSubtype.GENERAL_SOCIAL)
            .setNativeEventTrackers(listOf(eventTracker))
            .setNativeAssets(assets)
            .build()
    }

    private fun createNativeView(ad: NativeAd?) {
        if (ad == null) {
            Log.e(TAG, "Native ad is null. ")
            return
        }

        val nativeAd = ad.adMaterial
        val templateRenderingView = ATNativeAdView(this)
        templateRenderingView.layoutParams = FrameLayout.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.MATCH_PARENT
        )
        binding.groupRoot.addView(templateRenderingView)

        val notSelfRendering = ad.isNativeExpress
        var prepareInfo: ATNativePrepareInfo? = null
        if (notSelfRendering) {
            ad.renderAdContainer(templateRenderingView, null)
        } else {
            prepareInfo = ATNativePrepareInfo()
            createSelfRenderingAd(nativeAd, prepareInfo)
            ad.renderAdContainer(templateRenderingView, containerForAd)
        }
        ad.prepare(templateRenderingView, prepareInfo)
    }

    private fun createSelfRenderingAd(ad: ATNativeMaterial, prepareInfo: ATNativePrepareInfo) {
        val nativeContainer = View.inflate(this, R.layout.layout_native, null)
        nativeContainer.layoutParams = ViewGroup.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )

        val icon = nativeContainer.findViewById<ImageView>(R.id.imgIcon)
        download(ad.iconImageUrl, icon)
        prepareInfo.iconView = icon

        val title = nativeContainer.findViewById<TextView>(R.id.tvTitle)
        title.text = ad.title
        prepareInfo.titleView = title

        val image = nativeContainer.findViewById<ImageView>(R.id.imgImage)
        download(ad.mainImageUrl, image)
        prepareInfo.mainImageView = image

        val description = nativeContainer.findViewById<TextView>(R.id.tvDesc)
        description.text = ad.descriptionText
        prepareInfo.descView = description

        val cta = nativeContainer.findViewById<Button>(R.id.btnCta)
        cta.text = ad.callToActionText
        prepareInfo.ctaView = cta

        val clickableViews = ArrayList<View>()
        clickableViews.add(icon)
        clickableViews.add(title)
        clickableViews.add(image)
        clickableViews.add(description)
        clickableViews.add(cta)
        prepareInfo.clickViewList = clickableViews

        containerForAd.addView(nativeContainer)
    }

    private fun createListener(): ATNativeNetworkListener {
        return object : ATNativeNetworkListener {
            override fun onNativeAdLoaded() {
                createNativeView(adUnit!!.nativeAd)
            }

            override fun onNativeAdLoadFail(adError: AdError) {
                Log.e(TAG, "Ad loading failed: $adError")
            }
        }
    }

    companion object {
        private const val AD_UNIT_ID = "n1fskug7blk7jr"
    }
}
