/* 
 *  © 2024 Appstock 
 *  */

package com.appstock.demo.kotlin.testcases

import com.appstock.demo.kotlin.activities.ads.admob.*
import com.appstock.demo.kotlin.activities.ads.applovin.*
import com.appstock.demo.kotlin.activities.ads.inapp.*
import com.appstock.demo.kotlin.activities.ads.ironsource.IronSourceBannerActivity
import com.appstock.demo.kotlin.activities.ads.ironsource.IronSourceInterstitialActivity
import com.appstock.demo.kotlin.activities.ads.ironsource.IronSourceRewardedActivity
import com.appstock.demo.kotlin.activities.ads.topon.*

object TestCaseRepository {

    lateinit var lastTestCase: TestCase

    fun getList() = arrayListOf(
        TestCase(
            "Banner 300x250 (Appstock)",
            AdFormat.DISPLAY_BANNER,
            IntegrationKind.IN_APP,
            AppstockBannerActivity::class.java,
        ),
        TestCase(
            "Video Banner 300x250 (Appstock)",
            AdFormat.VIDEO_BANNER,
            IntegrationKind.IN_APP,
            AppstockVideoBannerActivity::class.java,
        ),
        TestCase(
            "Display Interstitial (Appstock)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.IN_APP,
            AppstockInterstitialActivity::class.java
        ),
        TestCase(
            "Video Interstitial (Appstock)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.IN_APP,
            AppstockVideoInterstitialActivity::class.java
        ),
        TestCase(
            "Display Rewarded (Appstock)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.IN_APP,
            AppstockRewardedActivity::class.java
        ),
        TestCase(
            "Video Rewarded (Appstock)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.IN_APP,
            AppstockVideoRewardedActivity::class.java
        ),
        TestCase(
            "Native (Appstock)",
            AdFormat.NATIVE,
            IntegrationKind.IN_APP,
            AppstockNativeActivity::class.java
        ),

        /* AdMob cases */
        TestCase(
            "Banner 300x250 (AdMob)",
            AdFormat.DISPLAY_BANNER,
            IntegrationKind.ADMOB,
            AdMobBannerActivity::class.java,
        ),
        TestCase(
            "Video Banner 300x250 (AdMob)",
            AdFormat.VIDEO_BANNER,
            IntegrationKind.ADMOB,
            AdMobVideoBannerActivity::class.java,
        ),
        TestCase(
            "Display Interstitial (AdMob)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.ADMOB,
            AdMobInterstitialActivity::class.java
        ),
        TestCase(
            "Video Interstitial (AdMob)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.ADMOB,
            AdMobVideoInterstitialActivity::class.java
        ),
        TestCase(
            "Display Rewarded (AdMob)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.ADMOB,
            AdMobRewardedActivity::class.java
        ),
        TestCase(
            "Video Rewarded (AdMob)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.ADMOB,
            AdMobVideoRewardedActivity::class.java
        ),
        TestCase(
            "Native (AdMob)",
            AdFormat.NATIVE,
            IntegrationKind.ADMOB,
            AdMobNativeActivity::class.java
        ),
        /* AppLovin cases */
        TestCase(
            "Banner 300x250 (AppLovin)",
            AdFormat.DISPLAY_BANNER,
            IntegrationKind.APPLOVIN,
            AppLovinBannerActivity::class.java,
        ),
        TestCase(
            "Video Banner 300x250 (AppLovin)",
            AdFormat.VIDEO_BANNER,
            IntegrationKind.APPLOVIN,
            AppLovinVideoBannerActivity::class.java,
        ),
        TestCase(
            "Display Interstitial (AppLovin)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.APPLOVIN,
            AppLovinInterstitialActivity::class.java
        ),
        TestCase(
            "Video Interstitial (AppLovin)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.APPLOVIN,
            AppLovinVideoInterstitialActivity::class.java
        ),
        TestCase(
            "Display Rewarded (AppLovin)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.APPLOVIN,
            AppLovinRewardedActivity::class.java
        ),
        TestCase(
            "Video Rewarded (AppLovin)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.APPLOVIN,
            AppLovinVideoRewardedActivity::class.java
        ),
        TestCase(
            "Native (AppLovin)",
            AdFormat.NATIVE,
            IntegrationKind.APPLOVIN,
            AppLovinNativeActivity::class.java
        ),
        /* TopOn */
        TestCase(
            "Banner 320x50 (TopOn)",
            AdFormat.DISPLAY_BANNER,
            IntegrationKind.TOPON,
            TopOnBannerActivity::class.java
        ),
        TestCase(
            "Video Banner 300x250 (TopOn)",
            AdFormat.DISPLAY_BANNER,
            IntegrationKind.TOPON,
            TopOnBannerVideoActivity::class.java
        ),
        TestCase(
            "Display Interstitial (TopOn)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.TOPON,
            TopOnInterstitialBannerActivity::class.java
        ),
        TestCase(
            "Video Interstitial (TopOn)",
            AdFormat.VIDEO_INTERSTITIAL,
            IntegrationKind.TOPON,
            TopOnInterstitialVideoActivity::class.java
        ),
        TestCase(
            "Native (TopOn)",
            AdFormat.NATIVE,
            IntegrationKind.TOPON,
            TopOnNativeActivity::class.java
        ),
        /* IronSource */
        TestCase(
            "Banner (IronSource)",
            AdFormat.DISPLAY_BANNER,
            IntegrationKind.IRONSOURCE,
            IronSourceBannerActivity::class.java
        ),
        TestCase(
            "Interstitial (IronSource)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.IRONSOURCE,
            IronSourceInterstitialActivity::class.java
        ),
        TestCase(
            "Rewarded (IronSource)",
            AdFormat.DISPLAY_INTERSTITIAL,
            IntegrationKind.IRONSOURCE,
            IronSourceRewardedActivity::class.java
        ),
    )

}