# Appstock Android SDK - Consent Management

Appstock SDK reads consent data provided by CMPs from User Settings and sends it in the ad request. You shouldn’t do
anything except to be sure that the CMP SDKs write data into particular place in the user storage defined by the IAB
standards.

The following table describes which data is used by SDK and how exactly:

| Storage Key                                                                                                                                                  | Description                                                                                                                                                                                                      |                                                    |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------|
| [TCF v2](https://github.com/InteractiveAdvertisingBureau/GDPR-Transparency-and-Consent-Framework/blob/master/TCFv2/IAB%20Tech%20Lab%20-%20CMP%20API%20v2.md) |                                                                                                                                                                                                                  |                                                    |
| `IABTCF_gdprApplies`                                                                                                                                         | Number: <br> 1 GDPR applies in current context <br> 0 - GDPR does not apply in current context <br> Unset - undetermined (default before initialization)                                                         | `regs.ext.gdpr`                                    |
| `IABTCF_TCString`                                                                                                                                            | String: Full encoded TC string                                                                                                                                                                                   | `user.ext.consent`                                 |
| `IABTCF_PurposeConsents`                                                                                                                                     | Binary String: The '0' or '1' at position n – where n's indexing begins at 0 – indicates the consent status for purpose ID n+1; false and true respectively. eg. '1' at index 0 is consent true for purpose ID 1 | Defines the ability of SDK to collect device info. |
| [CCPA](https://github.com/InteractiveAdvertisingBureau/USPrivacy/blob/master/CCPA/USP%20API.md)                                                              |                                                                                                                                                                                                                  |                                                    |
| `IABUSPrivacy_String`                                                                                                                                        | String: Aligns with IAB OpenRTB CCPA Advisory. <br> The String encodes all choices and information.                                                                                                              | `regs.ext.us_privacy`                              |
| [GPP](https://github.com/InteractiveAdvertisingBureau/Global-Privacy-Platform/blob/main/Core/CMP%20API%20Specification.md)                                   |                                                                                                                                                                                                                  |                                                    |
| `IABGPP_HDR_GppString`                                                                                                                                       | Full consent string in its encoded form                                                                                                                                                                          | `regs.gpp`                                         |
| `IABGPP_GppSID`                                                                                                                                              | Section ID(s) considered to be in force. Multiple IDs are separated by underscore, e.g. “2_3”                                                                                                                    | `regs.gpp_sid`                                     |