/* © 2024 Appstock */

#import "AppDelegate.h"

@interface AppDelegate ()
@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    // ===== INIT: Appstock SDK
    
    [Appstock initializeSDKWith:@"appstock-demo"];
    
    // ===== INIT: Google Mobile Ads SDK
    
    [GADMobileAds.sharedInstance startWithCompletionHandler:nil];
    [AppstockGADMediationAdapterInitializer start];
    
    // ===== INIT: AppLovin MAX SDK
    
    ALSdkInitializationConfiguration * config = [ALSdkInitializationConfiguration configurationWithSdkKey:@"<SDK_KEY>"];
    [ALSdk.shared initializeWithConfiguration:config 
                            completionHandler:^(ALSdkConfiguration * _Nonnull configuration) {}];
    
    // ===== INIT: TopOn
    
    [[ATAPI sharedInstance] startWithAppID:@"h66daf2d3e3bf9"
                                    appKey:@"acbf86cf9c9624fe445a6fed7d12c27c7"
                                     error:nil];

    return YES;
}


#pragma mark - UISceneSession lifecycle


- (UISceneConfiguration *)application:(UIApplication *)application
configurationForConnectingSceneSession:(UISceneSession *)connectingSceneSession
                              options:(UISceneConnectionOptions *)options {
    return [[UISceneConfiguration alloc] initWithName:@"Default Configuration" 
                                          sessionRole:connectingSceneSession.role];
}

- (void)application:(UIApplication *)application didDiscardSceneSessions:(NSSet<UISceneSession *> *)sceneSessions {}

@end
