/* © 2024 Appstock */

#import <UIKit/UIKit.h>
#import "IntegrationKind.h"
#import "IntegrationAdFormat.h"

typedef UIViewController* (^ConfigurationClosure)(void);

@interface IntegrationCase : NSObject

@property (nonatomic) NSString *title;
@property (nonatomic) IntegrationKind integrationKind;
@property (nonatomic) NSArray<NSNumber *> *adFormats;
@property (nonatomic) ConfigurationClosure configurationClosure;

-(id)initWithTitle:(NSString *)title integrationKind:(IntegrationKind)integrationKind
         adFormats:(NSArray<NSNumber *> *)adFormats configurationClosure:(ConfigurationClosure)configurationClosure;

@end
