/* © 2024 Appstock */

#import <Foundation/Foundation.h>
#import "IntegrationCaseManager.h"

#import "AppstockBannerAdViewController.h"
#import "AppstockVideoAdViewController.h"
#import "AppstockBannerInterstitialViewController.h"
#import "AppstockVideoInterstitialViewController.h"
#import "AppstockBannerRewardedViewController.h"
#import "AppstockVideoRewardedViewController.h"
#import "AppstockNativeViewController.h"

#import "AdMobBannerAdViewController.h"
#import "AdMobVideoAdViewController.h"
#import "AdMobBannerInterstitialViewController.h"
#import "AdMobVideoInterstitialViewController.h"
#import "AdMobBannerRewardedViewController.h"
#import "AdMobVideoRewardedViewController.h"
#import "AdMobNativeViewController.h"

#import "AppLovinBannerAdViewController.h"
#import "AppLovinVideoAdViewController.h"
#import "AppLovinBannerInterstitialViewController.h"
#import "AppLovinVideoInterstitialViewController.h"
#import "AppLovinBannerRewardedViewController.h"
#import "AppLovinVideoRewardedViewController.h"
#import "AppLovinNativeViewController.h"

#import "TopOnBannerAdViewController.h"
#import "TopOnVideoAdViewController.h"
#import "TopOnBannerInterstitialViewController.h"
#import "TopOnVideoInterstitialViewController.h"
#import "TopOnNativeViewController.h"

#import "IronSourceBannerVideoAdViewController.h"
#import "IronSourceBannerVideoInterstitialViewController.h"
#import "IronSourceBannerVideoRewardedViewController.h"

/**
    Integration case title template - [IntegrationKind] [IntegrationAdFormat]
    [IntegrationKind] - Appstock, AdMob, AppLovin
    [IntegrationAdFormat] - "Banner", "Video", "Banner Interstitial", "Video Interstitial", "Native"
 */

@implementation IntegrationCaseManager

+ (NSArray<IntegrationCase *> *)allCases {
    
    return
    [
        [NSArray alloc]
        initWithObjects:
            [
                [IntegrationCase alloc]
                initWithTitle:@"Appstock Banner Ad"
                integrationKind:IntegrationKindAppstock
                adFormats:@[@(IntegrationAdFormatBanner)]
                configurationClosure:^UIViewController *{
                    return [AppstockBannerAdViewController new];
                }
            ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"Appstock Video Ad"
            integrationKind:IntegrationKindAppstock
            adFormats:@[@(IntegrationAdFormatVideo)]
            configurationClosure:^UIViewController *{
                return [AppstockVideoAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"Appstock Banner Interstitial"
            integrationKind:IntegrationKindAppstock
            adFormats:@[@(IntegrationAdFormatBannerInterstitial)]
            configurationClosure:^UIViewController *{
                return [AppstockBannerInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"Appstock Video Interstitial"
            integrationKind:IntegrationKindAppstock
            adFormats:@[@(IntegrationAdFormatVideoInterstitial)]
            configurationClosure:^UIViewController *{
                return [AppstockVideoInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"Appstock Banner Rewarded"
            integrationKind:IntegrationKindAppstock
            adFormats:@[@(IntegrationAdFormatBannerRewarded)]
            configurationClosure:^UIViewController *{
                return [AppstockBannerRewardedViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"Appstock Video Rewarded"
            integrationKind:IntegrationKindAppstock
            adFormats:@[@(IntegrationAdFormatVideoRewarded)]
            configurationClosure:^UIViewController *{
                return [AppstockVideoRewardedViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"Appstock Native"
            integrationKind:IntegrationKindAppstock
            adFormats:@[@(IntegrationAdFormatNative)]
            configurationClosure:^UIViewController *{
                return [AppstockNativeViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Banner Ad"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatBanner)]
            configurationClosure:^UIViewController *{
                return [AdMobBannerAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Video Ad"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatVideo)]
            configurationClosure:^UIViewController *{
                return [AdMobVideoAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Banner Interstitial"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatBannerInterstitial)]
            configurationClosure:^UIViewController *{
                return [AdMobBannerInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Video Interstitial"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatVideoInterstitial)]
            configurationClosure:^UIViewController *{
                return [AdMobVideoInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Banner Rewarded"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatBannerRewarded)]
            configurationClosure:^UIViewController *{
                return [AdMobBannerRewardedViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Video Rewarded"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatVideoRewarded)]
            configurationClosure:^UIViewController *{
                return [AdMobVideoRewardedViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AdMob Native"
            integrationKind:IntegrationKindAdMob
            adFormats:@[@(IntegrationAdFormatNative)]
            configurationClosure:^UIViewController *{
                return [AdMobNativeViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Banner Ad"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatBanner)]
            configurationClosure:^UIViewController *{
                return [AppLovinBannerAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Video Ad"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatVideo)]
            configurationClosure:^UIViewController *{
                return [AppLovinVideoAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Banner Interstitial"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatBannerInterstitial)]
            configurationClosure:^UIViewController *{
                return [AppLovinBannerInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Video Interstitial"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatVideoInterstitial)]
            configurationClosure:^UIViewController *{
                return [AppLovinVideoInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Banner Rewarded"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatBannerRewarded)]
            configurationClosure:^UIViewController *{
                return [AppLovinBannerRewardedViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Video Rewarded"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatVideoRewarded)]
            configurationClosure:^UIViewController *{
                return [AppLovinVideoRewardedViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"AppLovin MAX Native"
            integrationKind:IntegrationKindAppLovin
            adFormats:@[@(IntegrationAdFormatNative)]
            configurationClosure:^UIViewController *{
                return [AppLovinNativeViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"TopOn Banner"
            integrationKind:IntegrationKindTopOn
            adFormats:@[@(IntegrationAdFormatBanner)]
            configurationClosure:^UIViewController *{
                return [TopOnBannerAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"TopOn Video"
            integrationKind:IntegrationKindTopOn
            adFormats:@[@(IntegrationAdFormatVideo)]
            configurationClosure:^UIViewController *{
                return [TopOnVideoAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"TopOn Banner Interstitial"
            integrationKind:IntegrationKindTopOn
            adFormats:@[@(IntegrationAdFormatBannerInterstitial)]
            configurationClosure:^UIViewController *{
                return [TopOnBannerInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"TopOn Video Interstitial"
            integrationKind:IntegrationKindTopOn
            adFormats:@[@(IntegrationAdFormatVideoInterstitial)]
            configurationClosure:^UIViewController *{
                return [TopOnVideoInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"TopOn Native"
            integrationKind:IntegrationKindTopOn
            adFormats:@[@(IntegrationAdFormatNative)]
            configurationClosure:^UIViewController *{
                return [TopOnNativeViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"ironSource Random Banner Video Ad"
            integrationKind:IntegrationKindIronSource
            adFormats:@[@(IntegrationAdFormatBanner), @(IntegrationAdFormatVideo)]
            configurationClosure:^UIViewController *{
                return [IronSourceBannerVideoAdViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"ironSource Random Banner Video Interstitial"
            integrationKind:IntegrationKindIronSource
            adFormats:@[@(IntegrationAdFormatBannerInterstitial), @(IntegrationAdFormatVideoInterstitial)]
            configurationClosure:^UIViewController *{
                return [IronSourceBannerVideoInterstitialViewController new];
            }
        ],
        
        [
            [IntegrationCase alloc]
            initWithTitle:@"ironSource Random Banner Video Rewarded"
            integrationKind:IntegrationKindIronSource
            adFormats:@[@(IntegrationAdFormatBannerRewarded), @(IntegrationAdFormatVideoRewarded)]
            configurationClosure:^UIViewController *{
                return [IronSourceBannerVideoRewardedViewController new];
            }
        ],
        
        nil];
}

@end
