/* © 2024 Appstock */

#import "AppLovinNativeViewController.h"

@interface AppLovinNativeViewController ()

@property (weak, nonatomic) IBOutlet MANativeAdView *maNativeAdView;

@property (nonatomic) MANativeAdLoader *nativeAdLoader;

@end

@implementation AppLovinNativeViewController

- (NSString *)adUnitId {
    return @"<AD_UNIT_ID>";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Bind the subviews using unique tag IDs with an instance of MANativeAdViewBinder
    MANativeAdViewBinder * binder = [
        [MANativeAdViewBinder alloc]
        initWithBuilderBlock:^(MANativeAdViewBinderBuilder * _Nonnull builder) {
            builder.iconImageViewTag = 1;
            builder.titleLabelTag = 2;
            builder.bodyLabelTag = 3;
            builder.advertiserLabelTag = 4;
            builder.callToActionButtonTag = 5;
        }
    ];
    
    [self.maNativeAdView bindViewsWithAdViewBinder:binder];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Create a MANativeAdLoader
    self.nativeAdLoader = [[MANativeAdLoader alloc] initWithAdUnitIdentifier:self.adUnitId];
    
    // 2. Configure the MANativeAdLoader
    self.nativeAdLoader.nativeAdDelegate = self;
    
    // 3. Configure the native parameters
    AppstockNativeAssetImage *image = [
        [AppstockNativeAssetImage alloc]
        initWithMinimumWidth:200
        minimumHeight:200
        required:true
    ];
    
    image.type = AppstockImageAsset.Main;
    
    AppstockNativeAssetImage *icon = [
        [AppstockNativeAssetImage alloc]
        initWithMinimumWidth:20
        minimumHeight:20
        required:true
    ];
    
    icon.type = AppstockImageAsset.Icon;
    
    AppstockNativeAssetTitle *title = [
        [AppstockNativeAssetTitle alloc]
        initWithLength:90
        required:true
    ];
    
    AppstockNativeAssetData *body = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetDescription
        required:true
    ];
    
    AppstockNativeAssetData *cta = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetCtatext
        required:true
    ];
    
    AppstockNativeAssetData *sponsored = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetSponsored
        required:true
    ];
    
    AppstockNativeParameters * parameters = [AppstockNativeParameters new];
    parameters.assets = @[title, icon, image, sponsored, body, cta];
    
    AppstockNativeEventTracker * eventTracker = [
        [AppstockNativeEventTracker alloc]
        initWithEvent:AppstockEventType.Impression
        methods:@[AppstockEventTracking.Image, AppstockEventTracking.js]
    ];
    
    parameters.eventtrackers = @[eventTracker];
    parameters.context = AppstockContextType.Social;
    parameters.placementType = AppstockPlacementType.FeedContent;
    parameters.contextSubType = AppstockContextSubType.Social;
    
    // 4. Create a AppstockAppLovinExtras
    AppstockAppLovinExtras * extras = [[AppstockAppLovinExtras alloc] 
                                       initWithNativeParameters: parameters];
    
    // 5. Set local extra parameter
    [self.nativeAdLoader setLocalExtraParameterForKey:AppstockAppLovinExtras.key value:extras];
    
    // 6. Load the ad
    [self.nativeAdLoader loadAdIntoAdView:self.maNativeAdView];
}

// MARK: - MANativeAdDelegate

- (void)didFailToLoadNativeAdForAdUnitIdentifier:(NSString *)adUnitIdentifier 
                                       withError:(MAError *)error {
    NSLog(@"Did fail to load ad with error: %@", error.message);
}

- (void)didLoadNativeAd:(MANativeAdView *)nativeAdView forAd:(MAAd *)ad {}
- (void)didClickNativeAd:(MAAd *)ad {}

@end
