/* © 2024 Appstock */

#import "AppstockBannerAdViewController.h"

@interface AppstockBannerAdViewController ()

@property (nonatomic) AppstockAdView * adView;

@end

@implementation AppstockBannerAdViewController

- (NSString *)placementID {
    return @"4";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Create a AppstockAdView
    self.adView = [[AppstockAdView alloc] initWithFrame:CGRectMake(0, 0, 300, 250)];
    
    // 2. Configure the AppstockAdView
    self.adView.placementID = self.placementID;
    self.adView.delegate = self;
    
    // Add Appstock ad view to the app UI
    [self.containerAdView addSubview:self.adView];
    
    // 3. Load the ad
    [self.adView loadAd];
}


// MARK: - AppstockAdViewDelegate

- (UIViewController *)adViewPresentationController {
    return self;
}

- (void)adView:(AppstockAdView *)adView didReceiveAdWithAdSize:(CGSize)adSize {
    // Called when ad is loaded. Deprecated.
}

- (void)adView:(AppstockAdView *)adView didReceiveAdWithAdSize:(CGSize)adSize adInfo:(AppstockAdInfo *)adInfo {
    // Called when ad is loaded.
    NSLog(@"Bid price: %@", adInfo.price ? adInfo.price : @"(null)");
}

- (void)adView:(AppstockAdView *)adView didFailToReceiveAdWith:(NSError *)error {
    // Called when Appstock SDK failed to load ad
    NSLog(@"Did fail to receive ad with error: %@", error.localizedDescription);
}

- (void)adViewWillPresentModal:(AppstockAdView *)adView {
    // Called when modal is about to be presented
}

- (void)adViewDidDismissModal:(AppstockAdView *)adView {
    // Called when modal is dismissed
}

- (void)adViewWillLeaveApplication:(AppstockAdView *)adView {
    // Called when the application is about to enter the background
}

@end
