/* © 2024 Appstock */

#import "AppstockBannerInterstitialViewController.h"

@interface AppstockBannerInterstitialViewController ()

@property (nonatomic) AppstockInterstitialAdUnit * interstitialAdUnit;

@end

@implementation AppstockBannerInterstitialViewController

- (NSString *)placementID {
    return @"5";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Create a AppstockInterstitialAdUnit
    self.interstitialAdUnit = [[AppstockInterstitialAdUnit alloc] init];
    
    // 2. Configure the AppstockInterstitialAdUnit
    self.interstitialAdUnit.placementID = self.placementID;
    self.interstitialAdUnit.delegate = self;
    
    // 3. Load the interstitial ad
    [self.interstitialAdUnit loadAd];
}


// MARK: - AppstockInterstitialAdUnitDelegate

- (void)interstitialDidReceiveAd:(AppstockInterstitialAdUnit *)interstitial {
    // Called when ad is loaded. Deprecated.
}

- (void)interstitialDidReceiveAd:(AppstockInterstitialAdUnit *)interstitial adInfo:(AppstockAdInfo *)adInfo {
    // Called when ad is loaded.
    [interstitial showFrom:self];
    
    NSLog(@"Bid price: %@", adInfo.price ? adInfo.price : @"(null)");
}

- (void)interstitial:(AppstockInterstitialAdUnit *)interstitial didFailToReceiveAdWithError:(NSError *)error {
    // Called when Appstock SDK failed to load ad
    NSLog(@"Did fail to receive ad with error: %@", error.localizedDescription);
}

- (void)interstitialWillPresentAd:(AppstockInterstitialAdUnit *)interstitial {
    // Called when interstitial is about to be presented
}

- (void)interstitialDidDismissAd:(AppstockInterstitialAdUnit *)interstitial {
    // Called when interstitial is dismissed
}

- (void)interstitialDidClickAd:(AppstockInterstitialAdUnit *)interstitial {
    // Called when interstitial was clicked
}

- (void)interstitialWillLeaveApplication:(AppstockInterstitialAdUnit *)interstitial {
    // Called when the application is about to enter the background
}

@end
