/* © 2024 Appstock */

#import "AppstockBannerRewardedViewController.h"

@interface AppstockBannerRewardedViewController ()

@property (nonatomic) AppstockRewardedAdUnit * rewardedAdUnit;

@end

@implementation AppstockBannerRewardedViewController

- (NSString *)placementID {
    return @"12";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Create a AppstockRewardedAdUnit
    self.rewardedAdUnit = [[AppstockRewardedAdUnit alloc] init];
    
    // 2. Configure the AppstockRewardedAdUnit
    self.rewardedAdUnit.placementID = self.placementID;
    self.rewardedAdUnit.delegate = self;
    
    // 3. Load the rewarded ad
    [self.rewardedAdUnit loadAd];
}

// MARK: - AppstockRewardedAdUnitDelegate

- (void)rewardedAdDidReceiveAd:(AppstockRewardedAdUnit *)rewardedAd {
    // Called when ad is loaded. Deprecated.
    [rewardedAd showFrom:self];
}

- (void)rewardedAdDidReceiveAd:(AppstockRewardedAdUnit *)rewardedAd adInfo:(AppstockAdInfo *)adInfo {
    // Called when ad is loaded.
    [rewardedAd showFrom:self];
    
    NSLog(@"Bid price: %@", adInfo.price ? adInfo.price : @"(null)");
}

- (void)rewardedAd:(AppstockRewardedAdUnit *)rewardedAd didFailToReceiveAdWithError:(NSError *)error {
    // Called when Appstock SDK failed to load ad
    NSLog(@"Did fail to receive ad with error: %@", error.localizedDescription);
}

- (void)rewardedAdWillPresentAd:(AppstockRewardedAdUnit *)rewardedAd {
    // Called when rewarded ad is about to be presented
}

- (void)rewardedAdDidDismissAd:(AppstockRewardedAdUnit *)rewardedAd {
    // Called when rewarded ad is dismissed
}

- (void)rewardedAdDidClickAd:(AppstockRewardedAdUnit *)rewardedAd {
    // Called when rewarded ad was clicked
}

- (void)rewardedAdWillLeaveApplication:(AppstockRewardedAdUnit *)rewardedAd {
    // Called when the application is about to enter the background
}

- (void)rewardedAdUserDidEarnReward:(AppstockRewardedAdUnit *)rewardedAd reward:(AppstockReward *)reward {
    // Called when the reward was granted to user
    NSLog(@"User did earn reward - type: %@, count: %f", reward.type, [reward.count doubleValue]);
}


@end
