/* © 2024 Appstock */

#import "AppstockNativeViewController.h"

@interface AppstockNativeViewController ()

@property (nonatomic) AppstockNativeAdUnit * nativeAdUnit;
@property (nonatomic, nullable) AppstockNativeAd * nativeAd;

@end

@implementation AppstockNativeViewController

- (NSString *)placementID {
    return @"9";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Create a AppstockNativeAdUnit
    self.nativeAdUnit = [[AppstockNativeAdUnit alloc] init];
    
    // 2. Configure the AppstockNativeAdUnit
    self.nativeAdUnit.placementID = self.placementID;
    
    AppstockNativeAssetImage *image = [
        [AppstockNativeAssetImage alloc]
        initWithMinimumWidth:200
        minimumHeight:200
        required:true
    ];
    
    image.type = AppstockImageAsset.Main;
    
    AppstockNativeAssetImage *icon = [
        [AppstockNativeAssetImage alloc]
        initWithMinimumWidth:20
        minimumHeight:20
        required:true
    ];
    
    icon.type = AppstockImageAsset.Icon;
    
    AppstockNativeAssetTitle *title = [
        [AppstockNativeAssetTitle alloc]
        initWithLength:90
        required:true
    ];
    
    AppstockNativeAssetData *body = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetDescription
        required:true
    ];
    
    AppstockNativeAssetData *cta = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetCtatext
        required:true
    ];
    
    AppstockNativeAssetData *sponsored = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetSponsored
        required:true
    ];
    
    AppstockNativeParameters * parameters = [AppstockNativeParameters new];
    parameters.assets = @[title, icon, image, sponsored, body, cta];
    
    AppstockNativeEventTracker * eventTracker = [
        [AppstockNativeEventTracker alloc]
        initWithEvent:AppstockEventType.Impression
        methods:@[AppstockEventTracking.Image, AppstockEventTracking.js]
    ];
    
    parameters.eventtrackers = @[eventTracker];
    parameters.context = AppstockContextType.Social;
    parameters.placementType = AppstockPlacementType.FeedContent;
    parameters.contextSubType = AppstockContextSubType.Social;
    
    self.nativeAdUnit.parameters = parameters;
    
    __weak typeof(self) weakSelf = self;
    [self.nativeAdUnit loadAdWithCompletion:^(AppstockNativeAd * _Nullable ad, NSError * _Nullable error) {
        if (error != nil || ad == nil) {
            return;
        }
        
        weakSelf.nativeAd = ad;
        weakSelf.nativeAd.delegate = self;
        
        weakSelf.titleLabel.text = ad.title;
        weakSelf.bodyLabel.text = ad.text;
        weakSelf.sponsoredLabel.text = ad.sponsoredBy;
        
        [weakSelf.mainImageView setImageFromURLString:ad.imageUrl
                                          placeholder:[UIImage systemImageNamed:@"photo.artframe"]];
        [weakSelf.iconView setImageFromURLString:ad.iconUrl
                                          placeholder:[UIImage systemImageNamed:@"photo.artframe"]];
        [weakSelf.callToActionButton setTitle:ad.callToAction forState:UIControlStateNormal];
        
        NSLog(@"Bid price: %@", weakSelf.nativeAd.adInfo.price ? weakSelf.nativeAd.adInfo.price : @"(null)");
    }];
}

// MARK: - AppstockNativeAdDelegate

- (void)adDidExpireWithAd:(AppstockNativeAd *)ad {
    // Called when the ad expired
}

- (void)adWasClickedWithAd:(AppstockNativeAd *)ad {
    // Called when the ad was clicked
}

- (void)adDidLogImpressionWithAd:(AppstockNativeAd *)ad {
    // Called when the impression was logged
}

@end
