/* © 2024 Appstock */

#import "TopOnBannerInterstitialViewController.h"

@implementation TopOnBannerInterstitialViewController

- (NSString *)placementID {
    return @"n66daf4813328c";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Load the ad
    [ATAdManager.sharedManager loadADWithPlacementID:self.placementID
                                               extra:@{}
                                            delegate:self];
}

// MARK: - ATAdLoadingDelegate

- (void)didFinishLoadingADWithPlacementID:(NSString *)placementID {
    // 2. Check if ad is ready to be shown
    if ([[ATAdManager sharedManager] interstitialReadyForPlacementID:placementID]) {
        // 3. Show the ad
        [[ATAdManager sharedManager] showInterstitialWithPlacementID:placementID
                                                    inViewController:self
                                                            delegate:self];
    }

}

- (void)didFailToLoadADWithPlacementID:(NSString *)placementID error:(NSError *)error {
    NSLog(@"Did fail to load ad: %@", error.localizedDescription);
}

- (void)didFailBiddingADSourceWithPlacementID:(NSString *)placementID
                                        extra:(NSDictionary *)extra
                                        error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didFailToLoadADSourceWithPlacementID:(NSString *)placementID
                                       extra:(NSDictionary *)extra
                                       error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didRevenueForPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didStartLoadingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didFinishLoadingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didStartBiddingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didFinishBiddingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}

// MARK: - ATInterstitialDelegate

- (void)interstitialDidShowForPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)interstitialDidClickForPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)interstitialDidCloseForPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}

@end
