/* © 2024 Appstock */

#import "IronSourceBannerVideoAdViewController.h"

@interface IronSourceBannerVideoAdViewController ()

@property (nonatomic, nullable) ISBannerView * bannerView;

@end

@implementation IronSourceBannerVideoAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
    
    // Destroy banner
    [IronSource destroyBanner:self.bannerView];
    [self.bannerView removeFromSuperview];
    self.bannerView = nil;
}

- (void)loadAd {
    // 1. Inititalize ironSource SDK
    [IronSource initWithAppKey:@"2277baa3d" adUnits:@[IS_BANNER]];
    
    // 2. Set banner delegate
    [IronSource setLevelPlayBannerDelegate:self];
    
    // 3. Create a size
    ISBannerSize * size = ISBannerSize_RECTANGLE;
    
    // 4. Load the ad
    [IronSource loadBannerWithViewController:self size:size];
}

// MARK: - LevelPlayBannerDelegate

- (void)didLoad:(ISBannerView *)bannerView withAdInfo:(ISAdInfo *)adInfo {
    self.bannerView = bannerView;
    
    // Add ironSource SDK banner view to the app UI
    [self.containerAdView addSubview:bannerView];
}

- (void)didFailToLoadWithError:(NSError *)error {
    NSLog(@"Did fail to load the ad: %@", error.localizedDescription);
}

- (void)didClickWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didPresentScreenWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didDismissScreenWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didLeaveApplicationWithAdInfo:(ISAdInfo *)adInfo {}

@end
