/* © 2024 Appstock */

#import "IronSourceBannerVideoInterstitialViewController.h"

@interface IronSourceBannerVideoInterstitialViewController ()

@end

@implementation IronSourceBannerVideoInterstitialViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Inititalize ironSource SDK
    [IronSource initWithAppKey:@"2277baa3d" adUnits:@[IS_INTERSTITIAL]];
    
    // 2. Set interstitial delegate
    [IronSource setLevelPlayInterstitialDelegate:self];
    
    // 3. Load the ad
    [IronSource loadInterstitial];
}

// MARK: - LevelPlayInterstitialDelegate

- (void)didLoadWithAdInfo:(ISAdInfo *)adInfo {
    // 4. Check if interstitial ad is available
    if([IronSource hasInterstitial]) {
        // 5. Show the ad
        [IronSource showInterstitialWithViewController:self];
    }
}

- (void)didFailToLoadWithError:(NSError *)error {
    NSLog(@"Did fail to load the ad: %@", error.localizedDescription);
}

- (void)didFailToShowWithError:(NSError *)error andAdInfo:(ISAdInfo *)adInfo {
    NSLog(@"Did fail to show the ad: %@", error.localizedDescription);
}

- (void)didOpenWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didShowWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didClickWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didCloseWithAdInfo:(ISAdInfo *)adInfo {}

@end
