/* © 2024 Appstock */

#import "IronSourceBannerVideoRewardedViewController.h"

@interface IronSourceBannerVideoRewardedViewController ()

@property(nonatomic) BOOL isRewardedShown;

@end

@implementation IronSourceBannerVideoRewardedViewController

- (instancetype)init
{
    self = [super init];
    if (self) {
        _isRewardedShown = false;
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Inititalize ironSource SDK
    [IronSource initWithAppKey:@"2277baa3d" adUnits:@[IS_REWARDED_VIDEO]];
    
    // 2. Set rewarded delegate
    [IronSource setLevelPlayRewardedVideoDelegate:self];
}

// MARK: - LevelPlayRewardedVideoDelegate

- (void)hasAvailableAdWithAdInfo:(ISAdInfo *)adInfo {
    // 3. Check if rewarded ad is available
    if([IronSource hasRewardedVideo] && !self.isRewardedShown) {
        // 4. Show the ad
        [IronSource showRewardedVideoWithViewController:self];
        self.isRewardedShown = true;
    }
}

- (void)hasNoAvailableAd {
    NSLog(@"No available ads");
}

- (void)didFailToShowWithError:(NSError *)error andAdInfo:(ISAdInfo *)adInfo {
    NSLog(@"Did fail to show the ad: %@", error.localizedDescription);
}

- (void)didReceiveRewardForPlacement:(ISPlacementInfo *)placementInfo withAdInfo:(ISAdInfo *)adInfo {
    NSLog(@"Did recieve reward");
}

- (void)didOpenWithAdInfo:(ISAdInfo *)adInfo {}
- (void)didClick:(ISPlacementInfo *)placementInfo withAdInfo:(ISAdInfo *)adInfo {}
- (void)didCloseWithAdInfo:(ISAdInfo *)adInfo {}

@end
