/*   Copyright 2019-2022 Prebid.org, Inc.
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

import UIKit

fileprivate let adBaseViewControllerNibName = "AdBaseViewController"

/// Base controller, which provides ad controls, i.e. ad view
class AdBaseViewController: UIViewController {
    
    @IBOutlet weak var containerAdView: UIView!
    
    convenience init() {
        self.init(nibName: adBaseViewControllerNibName, bundle: nil)
    }
}
