/* © 2024 Appstock */

import UIKit

import AppstockSDK

import GoogleMobileAds

fileprivate let adUnitId = "ca-app-pub-2844566227051243/7022752770"

final class AdMobVideoInterstitialViewController: InterstitialBaseViewController {
    
    private var interstitialAd: GoogleMobileAds.InterstitialAd?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Load the interstitial ad
        GoogleMobileAds.InterstitialAd.load(with: adUnitId, request: GoogleMobileAds.Request()) { [weak self] ad, error in
            guard error == nil && ad != nil else {
                return
            }
            
            self?.interstitialAd = ad
            
            // 2. Configure the interstitial ad
            self?.interstitialAd?.fullScreenContentDelegate = self
            
            // 3. Present the interstitial ad
            self?.interstitialAd?.present(from: self)
        }
    }
}

// MARK: - GADFullScreenContentDelegate

extension AdMobVideoInterstitialViewController: GoogleMobileAds.FullScreenContentDelegate {
    
    func ad(
        _ ad: any GoogleMobileAds.FullScreenPresentingAd,
        didFailToPresentFullScreenContentWithError error: any Error
    ) {
        print("Did fail to receive ad with error: \(error.localizedDescription)")
    }
}
