/* © 2024 Appstock */

import UIKit

import AppstockSDK

import GoogleMobileAds

fileprivate let adUnitId = "ca-app-pub-2844566227051243/4782448263"

final class AdMobVideoRewardedViewController: InterstitialBaseViewController {
    
    private var rewardedAd: GoogleMobileAds.RewardedAd!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Load the rewarded ad
        GoogleMobileAds.RewardedAd.load(with: adUnitId, request: GoogleMobileAds.Request()) { [weak self] ad, error in
            guard error == nil && ad != nil else {
                return
            }
            
            self?.rewardedAd = ad
            
            // 2. Configure the rewarded ad
            self?.rewardedAd.fullScreenContentDelegate = self
            
            // 3. Present the rewarded ad
            self?.rewardedAd.present(from: self, userDidEarnRewardHandler: {
                print("User did earn reward.")
            })
        }
    }
}

// MARK: - GoogleMobileAds.FullScreenContentDelegate

extension AdMobVideoRewardedViewController: GoogleMobileAds.FullScreenContentDelegate {
    
    func ad(
        _ ad: any GoogleMobileAds.FullScreenPresentingAd,
        didFailToPresentFullScreenContentWithError error: any Error
    ) {
        print("Did fail to receive ad with error: \(error.localizedDescription)")
    }
}
