/* © 2024 Appstock */

import AppstockSDK
import AppstockAppLovinMAXAdapter

import AppLovinSDK

fileprivate let adUnitId = "<AD_UNIT_ID>"

final class AppLovinNativeViewController: UIViewController {
    
    static var nib: String {
        "AppLovinNativeViewController"
    }
    
    @IBOutlet weak var maNativeAdView: MANativeAdView!
    
    private var nativeAdLoader: MANativeAdLoader!
    
    convenience init() {
        self.init(nibName: Self.nib, bundle: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Bind the subviews using unique tag IDs with an instance of MANativeAdViewBinder
        let binder = MANativeAdViewBinder { builder in
            builder.iconImageViewTag = 1
            builder.titleLabelTag = 2
            builder.bodyLabelTag = 3
            builder.advertiserLabelTag = 4
            builder.callToActionButtonTag = 5
        }
        
        maNativeAdView.bindViews(with: binder)
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a MANativeAdLoader
        nativeAdLoader = MANativeAdLoader(adUnitIdentifier: adUnitId)
        
        // 2. Configure the MANativeAdLoader
        nativeAdLoader.nativeAdDelegate = self
        
        // 3. Configure the native parameters
        let image = AppstockNativeAssetImage(minimumWidth: 200, minimumHeight: 50, required: true)
        image.type = .Main
        
        let icon = AppstockNativeAssetImage(minimumWidth: 20, minimumHeight: 20, required: true)
        icon.type = .Icon
        
        let title = AppstockNativeAssetTitle(length: 90, required: true)
        let body = AppstockNativeAssetData(type: .description, required: true)
        let cta = AppstockNativeAssetData(type: .ctatext, required: true)
        let sponsored = AppstockNativeAssetData(type: .sponsored, required: true)
        
        let parameters = AppstockNativeParameters()
        parameters.assets = [title, icon, image, sponsored, body, cta]
        
        let eventTracker = AppstockNativeEventTracker(
            event: .Impression,
            methods: [.Image, .js]
        )
        
        parameters.eventtrackers = [eventTracker]
        parameters.context = .Social
        parameters.placementType = .FeedContent
        parameters.contextSubType = .Social
        
        // 4. Create a AppstockAppLovinExtras
        let extras = AppstockAppLovinExtras(nativeParameters: parameters)
        
        // 5. Set local extra parameter
        nativeAdLoader.setLocalExtraParameterForKey(AppstockAppLovinExtras.key, value: extras)
        
        // 6. Load the ad
        nativeAdLoader.loadAd(into: maNativeAdView)
    }
}

extension AppLovinNativeViewController: MANativeAdDelegate {
    
    func didFailToLoadNativeAd(forAdUnitIdentifier adUnitIdentifier: String, withError error: MAError) {
        print("Did fail to load ad with error: \(error.message)")
    }
    
    func didLoadNativeAd(_ nativeAdView: MANativeAdView?, for ad: MAAd) {}
    func didClickNativeAd(_ ad: MAAd) {}
}
