/* © 2024 Appstock */

import UIKit
import AppstockSDK

fileprivate let placementID = "4"

final class AppstockBannerAdViewController: AdBaseViewController {
    
    private var adView: AppstockAdView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a AppstockAdView
        adView = AppstockAdView(
            frame: CGRect(origin: .zero, size: CGSize(width: 300, height: 250))
        )
        
        // 2. Configure the AppstockAdView
        adView.placementID = placementID
        adView.delegate = self
        
        // Add Appstock ad view to the app UI
        containerAdView.addSubview(adView)
        
        // 3. Load the ad
        adView.loadAd()
    }
}

// MARK: - AppstockAdViewDelegate

extension AppstockBannerAdViewController: AppstockAdViewDelegate {
    
    func adViewPresentationController() -> UIViewController? {
        self
    }
    
    func adView(_ adView: AppstockAdView, didReceiveAdWithAdSize adSize: CGSize) {
        // Called when ad is loaded. Deprecated.
    }
    
    func adView(_ adView: AppstockAdView, didReceiveAdWithAdSize adSize: CGSize, adInfo: AppstockAdInfo) {
        // Called when ad is loaded.
        print("Bid price: \(String(describing: adInfo.price))")
    }
    
    func adView(_ adView: AppstockAdView, didFailToReceiveAdWith error: any Error) {
        print("Did fail to receive ad with error: \(error.localizedDescription)")
    }
    
    func adViewWillPresentModal(_ adView: AppstockAdView) {
        // Called when modal is about to be presented
    }
    
    func adViewDidDismissModal(_ adView: AppstockAdView) {
        // Called when modal is dismissed
    }
    
    func adViewWillLeaveApplication(_ adView: AppstockAdView) {
        // Called when the application is about to enter the background
    }
}
