/* © 2024 Appstock */

import AppstockSDK
import IronSource

class IronSourceBannerVideoAdViewController: AdBaseViewController {
    
    private var bannerView: ISBannerView?

    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        
        // Destroy banner
        if let bannerView {
            IronSource.destroyBanner(bannerView)
            bannerView.removeFromSuperview()
            self.bannerView = nil
        }
    }
    
    private func loadAd() {
        // 1. Inititalize ironSource SDK
        IronSource.initWithAppKey("2277baa3d", adUnits: [IS_BANNER])
        
        // 2. Set banner delegate
        IronSource.setLevelPlayBannerDelegate(self)
        
        // 3. Create a size
        if let size = ISBannerSize(description: kSizeRectangle, width: 300, height: 250) {
            // 4. Load the ad
            IronSource.loadBanner(with: self, size: size)
        }
    }
}

// MARK: - LevelPlayBannerDelegate

extension IronSourceBannerVideoAdViewController: LevelPlayBannerDelegate {
    
    func didLoad(_ bannerView: ISBannerView!, with adInfo: ISAdInfo!) {
        self.bannerView = bannerView
        
        // Add ironSource SDK banner view to the app UI
        containerAdView.addSubview(bannerView)
    }
    
    func didFailToLoadWithError(_ error: (any Error)!) {
        print("Did fail to load ad with error: \(error.localizedDescription)")
    }
    
    func didClick(with adInfo: ISAdInfo!) {}
    func didLeaveApplication(with adInfo: ISAdInfo!) {}
    func didPresentScreen(with adInfo: ISAdInfo!) {}
    func didDismissScreen(with adInfo: ISAdInfo!) {}
}
