/* © 2024 Appstock */

import AppstockSDK
import IronSource

class IronSourceBannerVideoInterstitialViewController: InterstitialBaseViewController {

    override func viewDidLoad() {
        super.viewDidLoad()

        loadAd()
    }
    
    private func loadAd() {
        // 1. Inititalize ironSource SDK
        IronSource.initWithAppKey("2277baa3d", adUnits: [IS_INTERSTITIAL])
        
        // 2. Set interstitial delegate
        IronSource.setLevelPlayInterstitialDelegate(self)
        
        // 3. Load the ad
        IronSource.loadInterstitial()
    }
}

extension IronSourceBannerVideoInterstitialViewController: LevelPlayInterstitialDelegate {
    
    func didLoad(with adInfo: ISAdInfo!) {
        // 4. Check if interstitial ad is available
        if IronSource.hasInterstitial() {
            // 5. Show the ad
            IronSource.showInterstitial(with: self)
        }
    }
    
    func didFailToLoadWithError(_ error: (any Error)!) {
        print("Did fail to load the ad with error: \(error.localizedDescription)")
    }
    
    func didFailToShowWithError(_ error: (any Error)!, andAdInfo adInfo: ISAdInfo!) {
        print("Did fail to show the ad with error: \(error.localizedDescription)")
    }
    
    func didOpen(with adInfo: ISAdInfo!) {}
    func didShow(with adInfo: ISAdInfo!) {}
    func didClick(with adInfo: ISAdInfo!) {}
    func didClose(with adInfo: ISAdInfo!) {}
}
